/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.session;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.ejb.AccessTimeout;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.LockType;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInterceptorFactory;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.EJBComponentConfiguration;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.component.session.SessionInvocationContextInterceptor;
import org.jboss.as.ejb3.concurrency.ContainerManagedConcurrencyInterceptor;
import org.jboss.ejb3.concurrency.spi.LockableComponent;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public abstract class SessionBeanComponentConfiguration
extends EJBComponentConfiguration {
    private LockType beanLevelLockType;
    private AccessTimeout beanLevelAccessTimeout;
    private Map<EJBBusinessMethod, LockType> methodLevelLockTypes;
    private Map<EJBBusinessMethod, AccessTimeout> methodAccessTimeouts;
    private final Set<Method> asynchronousMethods = Collections.newSetFromMap(new IdentityHashMap());

    public SessionBeanComponentConfiguration(SessionBeanComponentDescription description) {
        super(description);
        this.beanLevelAccessTimeout = description.getBeanLevelAccessTimeout();
        if (description.allowsConcurrentAccess()) {
            this.beanLevelLockType = description.getBeanLevelLockType();
            if (description.getConcurrencyManagementType() != ConcurrencyManagementType.BEAN) {
                this.addComponentInstanceSystemInterceptorFactory((InterceptorFactory)new ComponentInterceptorFactory(){

                    protected Interceptor create(Component component, InterceptorFactoryContext context) {
                        if (component instanceof LockableComponent) {
                            return new ContainerManagedConcurrencyInterceptor((LockableComponent)component);
                        }
                        return new Interceptor(){

                            public Object processInvocation(InterceptorContext interceptorContext) throws Exception {
                                return interceptorContext.proceed();
                            }
                        };
                    }
                });
            }
        }
    }

    @Override
    protected void addCurrentInvocationContextInterceptorFactory() {
        this.addComponentSystemInterceptorFactory((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)SessionInvocationContextInterceptor.INSTANCE));
    }

    public LockType getBeanLevelLockType() {
        return this.beanLevelLockType;
    }

    public AccessTimeout getBeanLevelAccessTimeout() {
        return this.beanLevelAccessTimeout;
    }

    public Map<EJBBusinessMethod, LockType> getMethodApplicableLockTypes() {
        return this.methodLevelLockTypes;
    }

    public Map<EJBBusinessMethod, AccessTimeout> getMethodApplicableAccessTimeouts() {
        return this.methodAccessTimeouts;
    }

    protected void setMethodApplicableAccessTimeout(Map<EJBBusinessMethod, AccessTimeout> methodAccessTimeouts) {
        this.methodAccessTimeouts = methodAccessTimeouts;
    }

    protected void setMethodApplicableLockType(Map<EJBBusinessMethod, LockType> methodLockTypes) {
        this.methodLevelLockTypes = methodLockTypes;
    }

    public Set<Method> getAsynchronousMethods() {
        return this.asynchronousMethods;
    }

    public void addAsynchronousMethod(Method method) {
        this.asynchronousMethods.add(method);
    }
}

