/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.messagedriven;

import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentConfiguration;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class MessageDrivenComponentDescription
extends EJBComponentDescription {
    private String messageListenerInterfaceName;
    private String resourceAdapterName;

    public MessageDrivenComponentDescription(String componentName, String componentClassName, EEModuleDescription moduleDescription) {
        super(componentName, componentClassName, moduleDescription);
    }

    @Override
    public MethodIntf getMethodIntf(String viewClassName) {
        return MethodIntf.BEAN;
    }

    protected MessageDrivenComponentConfiguration constructComponentConfiguration() {
        return new MessageDrivenComponentConfiguration(this);
    }

    String getMessageListenerInterfaceName() {
        return this.messageListenerInterfaceName;
    }

    String getResourceAdapterName() {
        return this.resourceAdapterName;
    }

    protected void prepareComponentConfiguration(AbstractComponentConfiguration configuration, DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        super.prepareComponentConfiguration(configuration, phaseContext);
        MessageDrivenComponentConfiguration messageDrivenComponentConfiguration = (MessageDrivenComponentConfiguration)configuration;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ModuleClassLoader classLoader = module.getClassLoader();
        try {
            messageDrivenComponentConfiguration.setMessageListenerInterface(classLoader.loadClass(this.getMessageListenerInterfaceName()));
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException("Failed to load message listener interface " + this.getMessageListenerInterfaceName());
        }
    }

    public void setMessageListenerInterfaceName(String messageListenerInterfaceName) {
        this.getViewClassNames().add(messageListenerInterfaceName);
        this.messageListenerInterfaceName = messageListenerInterfaceName;
    }

    public void setResourceAdapterName(String resourceAdapterName) {
        this.resourceAdapterName = resourceAdapterName;
    }
}

