/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class EJBClientDescriptor10Parser
implements XMLElementReader<EJBClientDescriptorMetaData> {
    public static final String NAMESPACE_1_0 = "urn:jboss:ejb-client:1.0";
    public static final EJBClientDescriptor10Parser INSTANCE = new EJBClientDescriptor10Parser();

    private EJBClientDescriptor10Parser() {
    }

    public void readElement(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case CLIENT_CONTEXT: {
                            this.parseClientContext(reader, ejbClientDescriptorMetaData);
                            continue block7;
                        }
                    }
                    EJBClientDescriptor10Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor10Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor10Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private void parseClientContext(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    if (visited.contains((Object)element)) {
                        EJBClientDescriptor10Parser.unexpectedElement(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case EJB_RECEIVERS: {
                            this.parseEJBReceivers(reader, ejbClientDescriptorMetaData);
                            continue block7;
                        }
                    }
                    EJBClientDescriptor10Parser.unexpectedElement(reader);
                    continue block7;
                }
            }
            EJBClientDescriptor10Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor10Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private void parseEJBReceivers(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        boolean localReceiverPassByValue = true;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            String val = reader.getAttributeValue(i);
            switch (attribute) {
                case EXCLUDE_LOCAL_RECEIVER: {
                    boolean excludeLocalReceiver = Boolean.parseBoolean(val.trim());
                    ejbClientDescriptorMetaData.setExcludeLocalReceiver(excludeLocalReceiver);
                    continue block11;
                }
                case LOCAL_RECEIVER_PASS_BY_VALUE: {
                    localReceiverPassByValue = Boolean.parseBoolean(val.trim());
                    continue block11;
                }
                default: {
                    EJBClientDescriptor10Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        ejbClientDescriptorMetaData.setLocalReceiverPassByValue(localReceiverPassByValue);
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case REMOTING_EJB_RECEIVER: {
                            this.parseRemotingReceiver(reader, ejbClientDescriptorMetaData);
                            continue block12;
                        }
                    }
                    EJBClientDescriptor10Parser.unexpectedElement(reader);
                    continue block12;
                }
            }
            EJBClientDescriptor10Parser.unexpectedContent((XMLStreamReader)reader);
        }
        EJBClientDescriptor10Parser.unexpectedEndOfDocument(reader.getLocation());
    }

    private void parseRemotingReceiver(XMLExtendedStreamReader reader, EJBClientDescriptorMetaData ejbClientDescriptorMetaData) throws XMLStreamException {
        String outboundConnectionRef = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.OUTBOUND_CONNECTION_REF);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case OUTBOUND_CONNECTION_REF: {
                    outboundConnectionRef = reader.getAttributeValue(i).trim();
                    ejbClientDescriptorMetaData.addRemotingReceiverConnectionRef(outboundConnectionRef);
                    continue block3;
                }
                default: {
                    EJBClientDescriptor10Parser.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (!required.isEmpty()) {
            EJBClientDescriptor10Parser.missingAttributes(reader.getLocation(), required);
        }
    }

    private static void unexpectedEndOfDocument(Location location) throws XMLStreamException {
        throw EeMessages.MESSAGES.errorParsingEJBClientDescriptor("Unexpected end of document", location);
    }

    private static void missingAttributes(Location location, Set<Attribute> required) throws XMLStreamException {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (Attribute attribute : required) {
            b.append(' ').append((Object)attribute);
        }
        throw EeMessages.MESSAGES.errorParsingEJBClientDescriptor(b.toString(), location);
    }

    public static void unexpectedElement(XMLExtendedStreamReader reader) throws XMLStreamException {
        throw EeMessages.MESSAGES.unexpectedElement(reader.getName(), reader.getLocation());
    }

    private static void unexpectedContent(XMLStreamReader reader) throws XMLStreamException {
        String kind;
        switch (reader.getEventType()) {
            case 10: {
                kind = "attribute";
                break;
            }
            case 12: {
                kind = "cdata";
                break;
            }
            case 4: {
                kind = "characters";
                break;
            }
            case 5: {
                kind = "comment";
                break;
            }
            case 11: {
                kind = "dtd";
                break;
            }
            case 8: {
                kind = "document end";
                break;
            }
            case 2: {
                kind = "element end";
                break;
            }
            case 15: {
                kind = "entity declaration";
                break;
            }
            case 9: {
                kind = "entity ref";
                break;
            }
            case 13: {
                kind = "namespace";
                break;
            }
            case 14: {
                kind = "notation declaration";
                break;
            }
            case 3: {
                kind = "processing instruction";
                break;
            }
            case 6: {
                kind = "whitespace";
                break;
            }
            case 7: {
                kind = "document start";
                break;
            }
            case 1: {
                kind = "element start";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.hasName()) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.hasText()) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        throw EeMessages.MESSAGES.errorParsingEJBClientDescriptor(b.toString(), reader.getLocation());
    }

    static enum Attribute {
        EXCLUDE_LOCAL_RECEIVER,
        LOCAL_RECEIVER_PASS_BY_VALUE,
        OUTBOUND_CONNECTION_REF,
        UNKNOWN;

        private static final Map<QName, Attribute> attributes;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName("exclude-local-receiver"), EXCLUDE_LOCAL_RECEIVER);
            attributesMap.put(new QName("local-receiver-pass-by-value"), LOCAL_RECEIVER_PASS_BY_VALUE);
            attributesMap.put(new QName("outbound-connection-ref"), OUTBOUND_CONNECTION_REF);
            attributes = attributesMap;
        }
    }

    static enum Element {
        CLIENT_CONTEXT,
        EJB_RECEIVERS,
        JBOSS_EJB_CLIENT,
        REMOTING_EJB_RECEIVER,
        UNKNOWN;

        private static final Map<QName, Element> elements;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(EJBClientDescriptor10Parser.NAMESPACE_1_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(EJBClientDescriptor10Parser.NAMESPACE_1_0, "jboss-ejb-client"), JBOSS_EJB_CLIENT);
            elementsMap.put(new QName(EJBClientDescriptor10Parser.NAMESPACE_1_0, "client-context"), CLIENT_CONTEXT);
            elementsMap.put(new QName(EJBClientDescriptor10Parser.NAMESPACE_1_0, "ejb-receivers"), EJB_RECEIVERS);
            elementsMap.put(new QName(EJBClientDescriptor10Parser.NAMESPACE_1_0, "remoting-ejb-receiver"), REMOTING_EJB_RECEIVER);
            elements = elementsMap;
        }
    }
}

