/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component.deployers;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.ee.EeLogger;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.EnvEntryInjectionSource;
import org.jboss.as.ee.component.FixedInjectionSource;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.deployers.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.ee.component.deployers.MessageDestinationInjectionSource;
import org.jboss.as.ee.component.deployers.ResourceInjectionAnnotationParsingProcessor;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class ResourceReferenceProcessor
extends AbstractDeploymentDescriptorBindingsProcessor {
    @Override
    protected List<BindingConfiguration> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, EEModuleDescription moduleDescription, ComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        bindings.addAll(this.getEnvironmentEntries(environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription, applicationClasses));
        bindings.addAll(this.getResourceEnvRefEntries(environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription, applicationClasses));
        bindings.addAll(this.getResourceRefEntries(environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription, applicationClasses));
        bindings.addAll(this.getMessageDestinationRefs(environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription, applicationClasses, deploymentUnit));
        return bindings;
    }

    private List<BindingConfiguration> getResourceEnvRefEntries(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, ComponentDescription componentDescription, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        ResourceEnvironmentReferencesMetaData resourceEnvRefs = environment.getEnvironment().getResourceEnvironmentReferences();
        if (resourceEnvRefs == null) {
            return bindings;
        }
        for (ResourceEnvironmentReferenceMetaData resourceEnvRef : resourceEnvRefs) {
            BindingConfiguration bindingConfiguration;
            String name = resourceEnvRef.getName().startsWith("java:") ? resourceEnvRef.getName() : environment.getDefaultContext() + resourceEnvRef.getName();
            Class<?> classType = null;
            if (resourceEnvRef.getType() != null) {
                try {
                    classType = classLoader.loadClass(resourceEnvRef.getType());
                }
                catch (ClassNotFoundException e) {
                    throw EeMessages.MESSAGES.cannotLoad(e, resourceEnvRef.getType());
                }
            }
            LookupInjectionSource injectionSource = new LookupInjectionSource(name);
            classType = this.processInjectionTargets(moduleDescription, componentDescription, applicationClasses, injectionSource, classLoader, deploymentReflectionIndex, (ResourceInjectionMetaData)resourceEnvRef, classType);
            if (!this.isEmpty(resourceEnvRef.getLookupName())) {
                bindingConfiguration = new BindingConfiguration(name, new LookupInjectionSource(resourceEnvRef.getLookupName()));
            } else {
                if (classType == null) {
                    throw EeMessages.MESSAGES.cannotDetermineType(name);
                }
                String lookup = ResourceInjectionAnnotationParsingProcessor.FIXED_LOCATIONS.get(classType.getName());
                if (lookup != null) {
                    bindingConfiguration = new BindingConfiguration(name, new LookupInjectionSource(lookup));
                } else {
                    if (resourceEnvRef.getResourceEnvRefName().startsWith("java:")) {
                        EeLogger.ROOT_LOGGER.cannotResolve("resource-env-ref", name);
                        continue;
                    }
                    bindingConfiguration = new BindingConfiguration(name, new LookupInjectionSource("java:jboss/resources/" + resourceEnvRef.getResourceEnvRefName()));
                }
            }
            bindings.add(bindingConfiguration);
        }
        return bindings;
    }

    private List<BindingConfiguration> getResourceRefEntries(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, ComponentDescription componentDescription, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        ResourceReferencesMetaData resourceRefs = environment.getEnvironment().getResourceReferences();
        if (resourceRefs == null) {
            return bindings;
        }
        for (final ResourceReferenceMetaData resourceRef : resourceRefs) {
            BindingConfiguration bindingConfiguration;
            String name = resourceRef.getName().startsWith("java:") ? resourceRef.getName() : environment.getDefaultContext() + resourceRef.getName();
            Class<?> classType = null;
            if (resourceRef.getType() != null) {
                try {
                    classType = classLoader.loadClass(resourceRef.getType());
                }
                catch (ClassNotFoundException e) {
                    throw EeMessages.MESSAGES.cannotLoad(e, resourceRef.getType());
                }
            }
            LookupInjectionSource injectionSource = new LookupInjectionSource(name);
            classType = this.processInjectionTargets(moduleDescription, componentDescription, applicationClasses, injectionSource, classLoader, deploymentReflectionIndex, (ResourceInjectionMetaData)resourceRef, classType);
            if (!this.isEmpty(resourceRef.getLookupName())) {
                bindingConfiguration = new BindingConfiguration(name, new LookupInjectionSource(resourceRef.getLookupName()));
            } else if (!this.isEmpty(resourceRef.getResUrl())) {
                if (classType != null && classType.equals(URI.class)) {
                    try {
                        bindingConfiguration = new BindingConfiguration(name, new FixedInjectionSource(new ManagedReferenceFactory(){

                            public ManagedReference getReference() {
                                try {
                                    return new ValueManagedReference((Value)new ImmediateValue((Object)new URI(resourceRef.getResUrl())));
                                }
                                catch (URISyntaxException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }, new URI(resourceRef.getResUrl())));
                    }
                    catch (URISyntaxException e) {
                        throw EeMessages.MESSAGES.cannotParseResourceRefUri(e, resourceRef.getResUrl());
                    }
                } else {
                    try {
                        bindingConfiguration = new BindingConfiguration(name, new FixedInjectionSource(new ManagedReferenceFactory(){

                            public ManagedReference getReference() {
                                try {
                                    return new ValueManagedReference((Value)new ImmediateValue((Object)new URL(resourceRef.getResUrl())));
                                }
                                catch (MalformedURLException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }, new URL(resourceRef.getResUrl())));
                    }
                    catch (MalformedURLException e) {
                        throw EeMessages.MESSAGES.cannotParseResourceRefUri(e, resourceRef.getResUrl());
                    }
                }
            } else {
                if (classType == null) {
                    throw EeMessages.MESSAGES.cannotDetermineType(name);
                }
                String lookup = ResourceInjectionAnnotationParsingProcessor.FIXED_LOCATIONS.get(classType.getName());
                if (lookup != null) {
                    bindingConfiguration = new BindingConfiguration(name, new LookupInjectionSource(lookup));
                } else if (!resourceRef.getResourceRefName().startsWith("java:")) {
                    bindingConfiguration = new BindingConfiguration(name, new LookupInjectionSource("java:jboss/resources/" + resourceRef.getResourceRefName()));
                } else {
                    EeLogger.ROOT_LOGGER.cannotResolve("resource-env-ref", name);
                    continue;
                }
            }
            bindings.add(bindingConfiguration);
        }
        return bindings;
    }

    private List<BindingConfiguration> getEnvironmentEntries(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, ComponentDescription componentDescription, EEApplicationClasses applicationClasses) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        EnvironmentEntriesMetaData envEntries = environment.getEnvironment().getEnvironmentEntries();
        if (envEntries == null) {
            return bindings;
        }
        for (EnvironmentEntryMetaData envEntry : envEntries) {
            String name = envEntry.getName().startsWith("java:") ? envEntry.getName() : environment.getDefaultContext() + envEntry.getEnvEntryName();
            Class<?> classType = null;
            if (envEntry.getType() != null) {
                try {
                    classType = this.loadClass(envEntry.getType(), classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw EeMessages.MESSAGES.cannotLoad(e, envEntry.getType());
                }
            }
            String value = envEntry.getValue();
            String lookup = envEntry.getLookupName();
            if (!this.isEmpty(value) && !this.isEmpty(lookup)) {
                throw EeMessages.MESSAGES.cannotSpecifyBoth("<env-entry-value>", "<lookup-name>");
            }
            if (this.isEmpty(lookup) && this.isEmpty(value)) continue;
            LookupInjectionSource injectionSource = new LookupInjectionSource(name);
            if ((classType = this.processInjectionTargets(moduleDescription, componentDescription, applicationClasses, injectionSource, classLoader, deploymentReflectionIndex, (ResourceInjectionMetaData)envEntry, classType)) == null) {
                throw EeMessages.MESSAGES.cannotDetermineType("<env-entry>", name, "<env-entry-type>");
            }
            String type = classType.getName();
            BindingConfiguration bindingConfiguration = null;
            if (!this.isEmpty(lookup)) {
                bindingConfiguration = new BindingConfiguration(name, new LookupInjectionSource(lookup));
            } else if (type.equals(String.class.getName())) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(value));
            } else if (type.equals(Integer.class.getName()) || type.equals("int")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Integer.valueOf(value)));
            } else if (type.equals(Short.class.getName()) || type.equals("short")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Short.valueOf(value)));
            } else if (type.equals(Long.class.getName()) || type.equals("long")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Long.valueOf(value)));
            } else if (type.equals(Byte.class.getName()) || type.equals("byte")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Byte.valueOf(value)));
            } else if (type.equals(Double.class.getName()) || type.equals("double")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Double.valueOf(value)));
            } else if (type.equals(Float.class.getName()) || type.equals("float")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Float.valueOf(value)));
            } else if (type.equals(Boolean.class.getName()) || type.equals("boolean")) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Boolean.valueOf(value)));
            } else if (type.equals(Character.class.getName()) || type.equals("char")) {
                if (value.length() != 1) {
                    throw EeMessages.MESSAGES.invalidCharacterLength("env-entry", value);
                }
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Character.valueOf(value.charAt(0))));
            } else if (type.equals(Class.class.getName())) {
                try {
                    bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(classLoader.loadClass(value)));
                }
                catch (ClassNotFoundException e) {
                    throw EeMessages.MESSAGES.cannotLoad(value);
                }
            } else if (classType.isEnum() || classType.getEnclosingClass() != null && classType.getEnclosingClass().isEnum()) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Enum.valueOf(classType, value)));
            } else {
                throw EeMessages.MESSAGES.unknownElementType("env-entry", type);
            }
            bindings.add(bindingConfiguration);
        }
        return bindings;
    }

    private List<BindingConfiguration> getMessageDestinationRefs(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, ComponentDescription componentDescription, EEApplicationClasses applicationClasses, DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        MessageDestinationReferencesMetaData messageDestinationReferences = environment.getEnvironment().getMessageDestinationReferences();
        if (messageDestinationReferences == null) {
            return bindings;
        }
        for (MessageDestinationReferenceMetaData messageRef : messageDestinationReferences) {
            BindingConfiguration bindingConfiguration;
            String name = messageRef.getName().startsWith("java:") ? messageRef.getName() : environment.getDefaultContext() + messageRef.getName();
            Class<?> classType = null;
            if (messageRef.getType() != null) {
                try {
                    classType = classLoader.loadClass(messageRef.getType());
                }
                catch (ClassNotFoundException e) {
                    throw EeMessages.MESSAGES.cannotLoad(e, messageRef.getType());
                }
            }
            LookupInjectionSource injectionSource = new LookupInjectionSource(name);
            classType = this.processInjectionTargets(moduleDescription, componentDescription, applicationClasses, injectionSource, classLoader, deploymentReflectionIndex, (ResourceInjectionMetaData)messageRef, classType);
            if (!this.isEmpty(messageRef.getLookupName())) {
                bindingConfiguration = new BindingConfiguration(name, new LookupInjectionSource(messageRef.getLookupName()));
                bindings.add(bindingConfiguration);
                continue;
            }
            if (!this.isEmpty(messageRef.getMappedName())) {
                bindingConfiguration = new BindingConfiguration(name, new LookupInjectionSource(messageRef.getMappedName()));
                bindings.add(bindingConfiguration);
                continue;
            }
            if (!this.isEmpty(messageRef.getLink())) {
                MessageDestinationInjectionSource messageDestinationInjectionSource = new MessageDestinationInjectionSource(messageRef.getLink(), name);
                bindingConfiguration = new BindingConfiguration(name, messageDestinationInjectionSource);
                deploymentUnit.addToAttachmentList(Attachments.MESSAGE_DESTINATIONS, (Object)messageDestinationInjectionSource);
                bindings.add(bindingConfiguration);
                continue;
            }
            EeLogger.ROOT_LOGGER.cannotResolve("message-destination-ref", name);
        }
        return bindings;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }

    private Class<?> loadClass(String className, ClassLoader cl) throws ClassNotFoundException {
        if (className == null || className.trim().isEmpty()) {
            throw EeMessages.MESSAGES.cannotBeNullOrEmpty("Classname", className);
        }
        if (className.equals(Void.TYPE.getName())) {
            return Void.TYPE;
        }
        if (className.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (className.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        if (className.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (className.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        if (className.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (className.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (className.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (className.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        return Class.forName(className, false, cl);
    }
}

