/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;

public class MethodAwareInterceptorFactory
implements InterceptorFactory {
    private final Method method;
    private final InterceptorFactory delegate;

    public MethodAwareInterceptorFactory(InterceptorFactory delegate, Method method) {
        this.delegate = delegate;
        this.method = method;
    }

    public Interceptor create(InterceptorFactoryContext context) {
        return new MethodAwareInterceptor(this.method, this.delegate.create(context));
    }

    private static class MethodAwareInterceptor
    implements Interceptor {
        private final Method method;
        private final Interceptor delegate;

        public MethodAwareInterceptor(Method method, Interceptor delegate) {
            this.method = method;
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processInvocation(InterceptorContext context) throws Exception {
            Method oldMethod = context.getMethod();
            try {
                context.setMethod(this.method);
                Object object = this.delegate.processInvocation(context);
                return object;
            }
            finally {
                context.setMethod(oldMethod);
            }
        }
    }
}

