/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.List;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;

public final class ComponentAggregationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEApplicationDescription applicationDescription = new EEApplicationDescription();
        if (deploymentUnit.getAttachment(Attachments.DEPLOYMENT_TYPE) == DeploymentType.EAR) {
            List subdeployments = deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.SUB_DEPLOYMENTS);
            for (DeploymentUnit subdeployment : subdeployments) {
                EEModuleDescription moduleDescription = (EEModuleDescription)subdeployment.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
                if (moduleDescription == null) continue;
                for (AbstractComponentDescription componentDescription : moduleDescription.getComponentDescriptions()) {
                    applicationDescription.addComponent(componentDescription);
                }
                subdeployment.putAttachment(org.jboss.as.ee.component.Attachments.EE_APPLICATION_DESCRIPTION, (Object)applicationDescription);
            }
        } else if (deploymentUnit.getParent() == null) {
            EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
            if (moduleDescription == null) {
                return;
            }
            for (AbstractComponentDescription componentDescription : moduleDescription.getComponentDescriptions()) {
                applicationDescription.addComponent(componentDescription);
            }
            deploymentUnit.putAttachment(org.jboss.as.ee.component.Attachments.EE_APPLICATION_DESCRIPTION, (Object)applicationDescription);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

