/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.naming;

import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.Attachments;
import org.jboss.as.ee.naming.ContextNames;
import org.jboss.as.ee.naming.JavaNamespaceSetup;
import org.jboss.as.ee.naming.NamespaceSelectorService;
import org.jboss.as.ee.naming.RootContextService;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.ValueManagedObject;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Values;

public class ModuleContextProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule(moduleDescription.getAppName(), moduleDescription.getModuleName());
        RootContextService contextService = new RootContextService();
        serviceTarget.addService(moduleContextServiceName, (Service)contextService).install();
        BinderService moduleNameBinder = new BinderService("ModuleName");
        serviceTarget.addService(moduleContextServiceName.append(new String[]{"ModuleName"}), (Service)moduleNameBinder).addInjection(moduleNameBinder.getManagedObjectInjector(), (Object)new ValueManagedObject(Values.immediateValue((Object)moduleDescription.getModuleName()))).addDependency(moduleContextServiceName, NamingStore.class, moduleNameBinder.getNamingStoreInjector()).install();
        deploymentUnit.putAttachment(Attachments.MODULE_CONTEXT_CONFIG, (Object)moduleContextServiceName);
        ServiceName appNs = ContextNames.contextServiceNameOfApplication(moduleDescription.getAppName());
        ServiceName namespaceSelectorServiceName = deploymentUnit.getServiceName().append(NamespaceSelectorService.NAME);
        NamespaceSelectorService namespaceSelector = new NamespaceSelectorService();
        serviceTarget.addService(namespaceSelectorServiceName, (Service)namespaceSelector).addDependency(appNs, NamingStore.class, namespaceSelector.getApp()).addDependency(moduleContextServiceName, NamingStore.class, namespaceSelector.getModule()).addDependency(moduleContextServiceName, NamingStore.class, namespaceSelector.getComp()).install();
        JavaNamespaceSetup setupAction = new JavaNamespaceSetup(namespaceSelector);
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.SETUP_ACTIONS, (Object)setupAction);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

