/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.List;
import java.util.Map;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.AbstractComponentConfigProcessor;
import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.InterceptorMethodDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class InterceptorAnnotationParsingProcessor
extends AbstractComponentConfigProcessor {
    private static final DotName AROUND_INVOKE_ANNOTATION_NAME = DotName.createSimple((String)AroundInvoke.class.getName());

    @Override
    protected void processComponentConfig(DeploymentUnit deploymentUnit, DeploymentPhaseContext phaseContext, CompositeIndex index, AbstractComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        this.processClass(index, componentDescription, DotName.createSimple((String)componentDescription.getComponentClassName()), componentDescription.getComponentClassName(), true);
        for (InterceptorDescription descriptor : componentDescription.getAllInterceptors().values()) {
            this.processClass(index, DotName.createSimple((String)descriptor.getInterceptorClassName()), descriptor, componentDescription.getComponentClassName());
        }
    }

    private void processClass(CompositeIndex index, AbstractComponentDescription componentDescription, DotName className, String actualClassName, boolean declaredOnTargetClass) {
        InterceptorMethodDescription aroundInvokeMethod;
        ClassInfo classInfo = index.getClassByName(className);
        if (classInfo == null) {
            return;
        }
        DotName superName = classInfo.superName();
        if (superName != null) {
            this.processClass(index, componentDescription, superName, actualClassName, declaredOnTargetClass);
        }
        if ((aroundInvokeMethod = this.getAroundInvokeMethod(classInfo, actualClassName, declaredOnTargetClass)) != null) {
            componentDescription.addAroundInvokeMethod(aroundInvokeMethod);
        }
    }

    private void processClass(CompositeIndex index, DotName className, InterceptorDescription interceptorDescription, String actualClassName) {
        InterceptorMethodDescription aroundInvokeMethod;
        ClassInfo classInfo = index.getClassByName(className);
        if (classInfo == null) {
            return;
        }
        DotName superName = classInfo.superName();
        if (superName != null) {
            this.processClass(index, superName, interceptorDescription, actualClassName);
        }
        if ((aroundInvokeMethod = this.getAroundInvokeMethod(classInfo, actualClassName, false)) != null) {
            interceptorDescription.addAroundInvokeMethod(aroundInvokeMethod);
        }
    }

    private InterceptorMethodDescription getAroundInvokeMethod(ClassInfo classInfo, String actualClass, boolean declaredOnTargetClass) {
        if (classInfo == null) {
            return null;
        }
        Map classAnnotations = classInfo.annotations();
        List instances = (List)classAnnotations.get(AROUND_INVOKE_ANNOTATION_NAME);
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        if (instances.size() > 1) {
            throw new IllegalArgumentException("Only one method may be annotated with @AroundInvoke per bean.");
        }
        AnnotationTarget target = ((AnnotationInstance)instances.get(0)).target();
        if (!(target instanceof MethodInfo)) {
            throw new IllegalArgumentException("@AroundInvoke is only valid on method targets.");
        }
        MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
        this.validateArgumentType(classInfo, methodInfo);
        return InterceptorMethodDescription.create(classInfo.name().toString(), actualClass, methodInfo, declaredOnTargetClass);
    }

    private void validateArgumentType(ClassInfo classInfo, MethodInfo methodInfo) {
        Type[] args = methodInfo.args();
        switch (args.length) {
            case 0: {
                throw new IllegalArgumentException("Invalid argument signature.  Methods annotated with " + AROUND_INVOKE_ANNOTATION_NAME + " must have a single InvocationContext argument.");
            }
            case 1: {
                if (InvocationContext.class.getName().equals(args[0].name().toString())) break;
                throw new IllegalArgumentException("Invalid argument type.  Methods annotated with " + AROUND_INVOKE_ANNOTATION_NAME + " must have a single InvocationContext argument.");
            }
            default: {
                throw new IllegalArgumentException("Invalid number of arguments for method " + methodInfo.name() + " annotated with " + AROUND_INVOKE_ANNOTATION_NAME + " on class " + classInfo.name());
            }
        }
        if (!methodInfo.returnType().name().toString().equals(Object.class.getName())) {
            throw new IllegalArgumentException("@AroundInvoke methods must have an Object return type for " + methodInfo.name() + " annotated with " + AROUND_INVOKE_ANNOTATION_NAME + " on class " + classInfo.name());
        }
    }
}

