/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ee.component.LifecycleInterceptorFactory;
import org.jboss.as.ee.component.ResourceInjection;
import org.jboss.as.ee.component.SecurityActions;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.InterceptorInstanceFactory;
import org.jboss.invocation.SimpleInterceptorInstanceFactory;

public class InjectingInterceptorInstanceFactory
implements InterceptorInstanceFactory {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final SimpleInterceptorInstanceFactory delegate;
    private final Class<?> interceptorClass;
    private final List<LifecycleInterceptorFactory> postConstructInterceptorsMethods;
    private final List<LifecycleInterceptorFactory> preDestroyInterceptorsMethods;
    private final AbstractComponentConfiguration componentConfiguration;

    public InjectingInterceptorInstanceFactory(SimpleInterceptorInstanceFactory delegate, Class<?> interceptorClass, AbstractComponentConfiguration componentConfiguration, List<LifecycleInterceptorFactory> postConstructInterceptorsMethods, List<LifecycleInterceptorFactory> preDestroyInterceptorsMethods) {
        this.delegate = delegate;
        this.interceptorClass = interceptorClass;
        this.componentConfiguration = componentConfiguration;
        this.postConstructInterceptorsMethods = postConstructInterceptorsMethods;
        this.preDestroyInterceptorsMethods = preDestroyInterceptorsMethods;
    }

    public Object createInstance(InterceptorFactoryContext context) {
        Class<?> instanceClass;
        Map map = context.getContextData();
        if (map.containsKey(instanceClass = this.interceptorClass)) {
            return map.get(instanceClass);
        }
        Object instance = this.delegate.createInstance(context);
        List<ResourceInjection> interceptorInjections = this.componentConfiguration.getInterceptorResourceInjections(this.interceptorClass);
        if (interceptorInjections != null) {
            for (ResourceInjection injection : interceptorInjections) {
                injection.inject(instance);
            }
        }
        this.performPostConstructLifecycle(instance, context);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performPostConstructLifecycle(Object instance, InterceptorFactoryContext interceptorContext) {
        List<LifecycleInterceptorFactory> postConstructInterceptorMethods = this.postConstructInterceptorsMethods;
        if (postConstructInterceptorMethods == null || postConstructInterceptorMethods.isEmpty()) return;
        ClassLoader contextCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.interceptorClass.getClassLoader());
        try {
            for (LifecycleInterceptorFactory postConstructMethod : postConstructInterceptorMethods) {
                try {
                    Interceptor interceptor = postConstructMethod.create(interceptorContext);
                    InterceptorContext context = new InterceptorContext();
                    context.setTarget(instance);
                    context.setContextData(new HashMap());
                    context.setParameters(EMPTY_OBJECT_ARRAY);
                    interceptor.processInvocation(context);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to invoke post construct method for class " + this.interceptorClass, t);
                    return;
                }
            }
        }
        finally {
            SecurityActions.setContextClassLoader(contextCl);
        }
    }
}

