/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.deployment.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.jboss.logging.Logger;

public final class JarUtils {
    private static final Logger log = Logger.getLogger(JarUtils.class);

    public static String[] addJar(JarOutputStream outputStream, String prefix, File jar) throws IOException {
        log.trace((Object)("addJar: " + jar));
        ArrayList<String> tmp = new ArrayList<String>();
        FileInputStream fis = new FileInputStream(jar);
        JarInputStream jis = new JarInputStream(fis);
        JarEntry entry = jis.getNextJarEntry();
        while (entry != null) {
            if (!entry.isDirectory()) {
                String entryName = prefix + entry.getName();
                tmp.add(entryName);
                JarUtils.addJarEntry(outputStream, entryName, jis);
            }
            entry = jis.getNextJarEntry();
        }
        jis.close();
        String[] names = new String[tmp.size()];
        tmp.toArray(names);
        return names;
    }

    public static void addJarEntry(JarOutputStream outputStream, String entryName, InputStream inputStream) throws IOException {
        log.trace((Object)("addJarEntry: " + entryName));
        outputStream.putNextEntry(new JarEntry(entryName));
        JarUtils.copyStream(outputStream, inputStream);
    }

    public static void copyStream(OutputStream outputStream, InputStream inputStream) throws IOException {
        byte[] bytes = new byte[4096];
        int read = inputStream.read(bytes, 0, 4096);
        while (read > 0) {
            outputStream.write(bytes, 0, read);
            read = inputStream.read(bytes, 0, 4096);
        }
    }
}

