/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.server.deployment.scanner.DeploymentScannerService;
import org.jboss.as.server.deployment.scanner.DeploymentSubsystemDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class DeploymentScannerAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static final String OPERATION_NAME = "add";
    static final DeploymentScannerAdd INSTANCE = new DeploymentScannerAdd();

    private DeploymentScannerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String path = operation.require("path").asString();
        Boolean enabled = operation.hasDefined("scan-enabled") ? operation.get("scan-enabled").asBoolean() : true;
        Integer interval = operation.hasDefined("scan-interval") ? operation.get("scan-interval").asInt() : 5000;
        String relativeTo = operation.hasDefined("relative-to") ? operation.get("relative-to").asString() : null;
        Boolean autoDeployZip = operation.hasDefined("auto-deploy-zipped") ? operation.get("auto-deploy-zipped").asBoolean() : true;
        Boolean autoDeployExp = operation.hasDefined("auto-deploy-exploded") ? operation.get("auto-deploy-exploded").asBoolean() : false;
        Long deploymentTimeout = operation.hasDefined("deployment-timeout") ? operation.get("deployment-timeout").asLong() : 60L;
        model.get("name").set(name);
        model.get("path").set(path);
        if (enabled != null) {
            model.get("scan-enabled").set(enabled.booleanValue());
        }
        if (interval != null) {
            model.get("scan-interval").set(interval.intValue());
        }
        if (autoDeployZip != null) {
            model.get("auto-deploy-zipped").set(autoDeployZip.booleanValue());
        }
        if (autoDeployExp != null) {
            model.get("auto-deploy-exploded").set(autoDeployExp.booleanValue());
        }
        if (relativeTo != null) {
            model.get("relative-to").set(relativeTo);
        }
        if (deploymentTimeout != null) {
            model.get("deployment-timeout").set(deploymentTimeout.longValue());
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String path = operation.require("path").asString();
        Boolean enabled = operation.hasDefined("scan-enabled") ? operation.get("scan-enabled").asBoolean() : true;
        Integer interval = operation.hasDefined("scan-interval") ? operation.get("scan-interval").asInt() : 5000;
        String relativeTo = operation.hasDefined("relative-to") ? operation.get("relative-to").asString() : null;
        Boolean autoDeployZip = operation.hasDefined("auto-deploy-zipped") ? operation.get("auto-deploy-zipped").asBoolean() : true;
        Boolean autoDeployExp = operation.hasDefined("auto-deploy-exploded") ? operation.get("auto-deploy-exploded").asBoolean() : false;
        Long deploymentTimeout = operation.hasDefined("deployment-timeout") ? operation.get("deployment-timeout").asLong() : 60L;
        ServiceTarget serviceTarget = context.getServiceTarget();
        DeploymentScannerService.addService(serviceTarget, name, relativeTo, path, interval, TimeUnit.MILLISECONDS, autoDeployZip, autoDeployExp, enabled, deploymentTimeout, newControllers, new ServiceListener[]{verificationHandler});
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentSubsystemDescriptions.getScannerAdd(locale);
    }
}

