/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.deployment.scanner.DeploymentSubsystemDescriptions;
import org.jboss.dmr.ModelNode;

public class DeploymentScannerSubsystemRemove
implements ModelRemoveOperationHandler,
DescriptionProvider {
    static final String OPERATION_NAME = "remove";
    static final DeploymentScannerSubsystemRemove INSTANCE = new DeploymentScannerSubsystemRemove();

    private DeploymentScannerSubsystemRemove() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode subsystem = context.getSubModel();
        if (subsystem.hasDefined("scanner") && subsystem.get("scanner").asInt() > 0) {
            throw new OperationFailedException(new ModelNode().set("Cannot remove subsystem while it still has scanners configured. Remove all scanners first."));
        }
        ModelNode compensatingOperation = Util.getEmptyOperation((String)"add", (ModelNode)operation.get("address"));
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOperation);
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentSubsystemDescriptions.getSubsystemRemove(locale);
    }
}

