/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.deployment.scanner.DeploymentScannerService;
import org.jboss.as.server.deployment.scanner.DeploymentSubsystemDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;

class DeploymentScannerAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    static final String OPERATION_NAME = "add";
    static final DeploymentScannerAdd INSTANCE = new DeploymentScannerAdd();

    private DeploymentScannerAdd() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        ModelNode opAddr = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        final String path = operation.require("path").asString();
        final Boolean enabled = operation.hasDefined("scan-enabled") ? Boolean.valueOf(operation.get("scan-enabled").asBoolean()) : null;
        final Integer interval = operation.hasDefined("scan-interval") ? Integer.valueOf(operation.get("scan-interval").asInt()) : null;
        final String relativeTo = operation.hasDefined("relative-to") ? operation.get("relative-to").asString() : null;
        final Boolean autoDeployZip = operation.hasDefined("auto-deploy-zipped") ? Boolean.valueOf(operation.get("auto-deploy-zipped").asBoolean()) : null;
        final Boolean autoDeployExp = operation.hasDefined("auto-deploy-exploded") ? Boolean.valueOf(operation.get("auto-deploy-exploded").asBoolean()) : null;
        final Long deploymentTimeout = operation.hasDefined("deployment-timeout") ? Long.valueOf(operation.get("deployment-timeout").asLong()) : null;
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)opAddr);
        ModelNode subModel = context.getSubModel();
        subModel.get("name").set(name);
        subModel.get("path").set(path);
        if (enabled != null) {
            subModel.get("scan-enabled").set(enabled.booleanValue());
        }
        if (interval != null) {
            subModel.get("scan-interval").set(interval.intValue());
        }
        if (autoDeployZip != null) {
            subModel.get("auto-deploy-zipped").set(autoDeployZip.booleanValue());
        }
        if (autoDeployExp != null) {
            subModel.get("auto-deploy-exploded").set(autoDeployExp.booleanValue());
        }
        if (relativeTo != null) {
            subModel.get("relative-to").set(relativeTo);
        }
        if (deploymentTimeout != null) {
            subModel.get("deployment-timeout").set(deploymentTimeout.longValue());
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    DeploymentScannerService.addService(serviceTarget, name, relativeTo, path, interval, TimeUnit.MILLISECONDS, autoDeployZip, autoDeployExp, enabled, deploymentTimeout);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentSubsystemDescriptions.getScannerAdd(locale);
    }
}

