/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.server.deployment.scanner.DeploymentScannerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

class DeploymentScannerRemove
implements ModelRemoveOperationHandler {
    static final DeploymentScannerRemove INSTANCE = new DeploymentScannerRemove();

    private DeploymentScannerRemove() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        ModelNode subModel = new ModelNode();
        ModelNode compensatingOperation = new ModelNode();
        compensatingOperation.get("operation").set("add");
        compensatingOperation.get("address").set(operation.require("address"));
        compensatingOperation.get("path").set(subModel.get("path"));
        compensatingOperation.get("scan-enabled").set(subModel.get("scan-enabled"));
        compensatingOperation.get("scan-interval").set(subModel.get("scan-interval"));
        compensatingOperation.get("relative-to").set(subModel.get("relative-to"));
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry().getService(DeploymentScannerService.getServiceName(name));
                    if (controller != null) {
                        controller.addListener((ServiceListener)new ResultHandler.ServiceRemoveListener(resultHandler));
                    } else {
                        resultHandler.handleResultComplete();
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensatingOperation);
    }
}

