/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;

public class RemoteProxyController
extends AbstractMessageHandler<Void, ExecuteRequestContext>
implements ProxyController {
    private final PathAddress pathAddress;
    private final Channel channel;
    private final ProxyOperationAddressTranslator addressTranslator;

    private RemoteProxyController(ExecutorService executorService, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator, Channel channel) {
        super(executorService);
        this.pathAddress = pathAddress;
        this.channel = channel;
        this.addressTranslator = addressTranslator;
    }

    public static RemoteProxyController create(ExecutorService executorService, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator, Channel channel) {
        return new RemoteProxyController(executorService, pathAddress, addressTranslator, channel);
    }

    @Override
    public PathAddress getProxyNodeAddress() {
        return this.pathAddress;
    }

    protected ManagementRequestHeader validateRequest(ManagementProtocolHeader header) throws IOException {
        ManagementRequestHeader request = super.validateRequest(header);
        return request;
    }

    protected ManagementRequestHandler<Void, ExecuteRequestContext> getRequestHandler(byte operationType) {
        if (operationType == 72) {
            return new HandleReportRequestHandler();
        }
        if (operationType == 73) {
            return new OperationFailedRequestHandler();
        }
        if (operationType == 74) {
            return new OperationCompletedRequestHandler();
        }
        if (operationType == 75) {
            return new OperationPreparedRequestHandler();
        }
        if (operationType == 76) {
            return new ReadAttachmentInputStreamRequestHandler();
        }
        return super.getRequestHandler(operationType);
    }

    @Override
    public void execute(ModelNode original, OperationMessageHandler handler, ProxyController.ProxyOperationControl control, OperationAttachments attachments) {
        ModelNode operation = this.getOperationForProxy(original);
        ExecuteRequestContext context = new ExecuteRequestContext(operation, attachments, handler, control);
        try {
            ActiveOperation support = super.registerActiveOperation((Object)context, (ActiveOperation.CompletedCallback)context);
            super.executeRequest((ManagementRequest)new ExecuteRequest(), this.channel, support);
            context.awaitPreparedOrFailed();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ModelNode getOperationForProxy(ModelNode op) {
        PathAddress translated;
        PathAddress addr = PathAddress.pathAddress(op.get("address"));
        if (addr.equals(translated = this.addressTranslator.translateAddress(addr))) {
            return op;
        }
        ModelNode proxyOp = op.clone();
        proxyOp.get("address").set(translated.toModelNode());
        return proxyOp;
    }

    static ModelNode getResponse(String outcome) {
        ModelNode response = new ModelNode();
        response.get("outcome").set(outcome);
        return response;
    }

    static class ExecuteRequestContext
    implements ActiveOperation.CompletedCallback<Void> {
        final ModelNode operation;
        final OperationAttachments attachments;
        final OperationMessageHandler messageHandler;
        final ProxyController.ProxyOperationControl control;
        final AtomicBoolean completed = new AtomicBoolean(false);
        final CountDownLatch prepareOrFailedLatch = new CountDownLatch(1);

        public ExecuteRequestContext(ModelNode operation, OperationAttachments attachments, OperationMessageHandler messageHandler, final ProxyController.ProxyOperationControl delegate) {
            this.control = new ProxyController.ProxyOperationControl(){

                @Override
                public void operationFailed(ModelNode response) {
                    if (ExecuteRequestContext.this.completed.compareAndSet(false, true)) {
                        delegate.operationFailed(response);
                    }
                    ExecuteRequestContext.this.prepareOrFailedLatch.countDown();
                }

                @Override
                public void operationCompleted(ModelNode response) {
                    if (ExecuteRequestContext.this.completed.compareAndSet(false, true)) {
                        delegate.operationCompleted(response);
                    }
                }

                @Override
                public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                    delegate.operationPrepared(transaction, result);
                    ExecuteRequestContext.this.prepareOrFailedLatch.countDown();
                }
            };
            this.operation = operation;
            this.attachments = attachments;
            this.messageHandler = messageHandler;
        }

        public OperationMessageHandler getMessageHandler() {
            return this.messageHandler;
        }

        public ModelNode getOperation() {
            return this.operation;
        }

        public OperationAttachments getAttachments() {
            return this.attachments;
        }

        public List<InputStream> getInputStreams() {
            OperationAttachments attachments = this.getAttachments();
            if (attachments == null) {
                return Collections.emptyList();
            }
            return attachments.getInputStreams();
        }

        public ProxyController.ProxyOperationControl getControl() {
            return this.control;
        }

        public void awaitPreparedOrFailed() throws InterruptedException {
            this.prepareOrFailedLatch.await();
        }

        public void completed(Void result) {
        }

        public void failed(Exception e) {
            this.control.operationFailed(RemoteProxyController.getResponse("failed"));
            this.prepareOrFailedLatch.countDown();
        }

        public void cancelled() {
            this.control.operationFailed(RemoteProxyController.getResponse("cancelled"));
            this.prepareOrFailedLatch.countDown();
        }
    }

    private class OperationPreparedRequestHandler
    extends ProxyOperationControlRequestHandler {
        private OperationPreparedRequestHandler() {
        }

        @Override
        void handle(ModelNode response, final ActiveOperation.ResultHandler<Void> resultHandler, final ManagementRequestContext<ExecuteRequestContext> context) {
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            executeRequestContext.getControl().operationPrepared(new ModelController.OperationTransaction(){

                @Override
                public void rollback() {
                    this.done(false);
                }

                @Override
                public void commit() {
                    this.done(true);
                }

                private void done(boolean commit) {
                    final byte status = commit ? (byte)112 : 113;
                    ActiveOperation activeOperation = RemoteProxyController.this.getActiveOperation(context.getOperationId());
                    try {
                        RemoteProxyController.this.executeRequest((ManagementRequest)new AbstractManagementRequest<Void, ExecuteRequestContext>(){

                            public byte getOperationType() {
                                return 78;
                            }

                            protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> executeRequestContextManagementRequestContext, FlushableDataOutput output) throws IOException {
                                output.write((int)status);
                            }

                            public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> executeRequestContextManagementRequestContext) throws IOException {
                            }
                        }, RemoteProxyController.this.channel, activeOperation);
                    }
                    catch (Exception e) {
                        resultHandler.failed(e);
                    }
                    try {
                        activeOperation.getResult().await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw ControllerMessages.MESSAGES.transactionTimeout(commit ? "commit" : "rollback");
                    }
                }
            }, response);
        }
    }

    private class OperationCompletedRequestHandler
    extends ProxyOperationControlRequestHandler {
        private OperationCompletedRequestHandler() {
        }

        @Override
        void handle(ModelNode response, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) {
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            executeRequestContext.getControl().operationCompleted(response);
            resultHandler.done(null);
        }
    }

    private class OperationFailedRequestHandler
    extends ProxyOperationControlRequestHandler {
        private OperationFailedRequestHandler() {
        }

        @Override
        void handle(ModelNode response, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) {
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            executeRequestContext.getControl().operationFailed(response);
        }
    }

    abstract class ProxyOperationControlRequestHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        ProxyOperationControlRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)100);
            ModelNode response = new ModelNode();
            response.readExternal(input);
            this.handle(response, resultHandler, context);
            context.executeAsync(ProtocolUtils.emptyResponseTask());
        }

        abstract void handle(ModelNode var1, ActiveOperation.ResultHandler<Void> var2, ManagementRequestContext<ExecuteRequestContext> var3);
    }

    private class ReadAttachmentInputStreamRequestHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        private ReadAttachmentInputStreamRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)102);
            final int index = input.readInt();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    ExecuteRequestContext exec = (ExecuteRequestContext)context.getAttachment();
                    ManagementRequestHeader header = (ManagementRequestHeader)ManagementRequestHeader.class.cast(context.getRequestHeader());
                    ManagementResponseHeader response = new ManagementResponseHeader(header.getVersion(), header.getRequestId(), null);
                    InputStream is = (InputStream)exec.getAttachments().getInputStreams().get(index);
                    ByteArrayOutputStream bout = ReadAttachmentInputStreamRequestHandler.this.copyStream(is);
                    FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)response);
                    try {
                        output.writeByte(103);
                        output.writeInt(bout.size());
                        output.writeByte(104);
                        output.write(bout.toByteArray());
                        output.writeByte(36);
                        output.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)output);
                    }
                }
            });
        }

        protected ByteArrayOutputStream copyStream(InputStream is) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (is != null) {
                StreamUtils.copyStream((InputStream)is, (OutputStream)bout);
            }
            return bout;
        }
    }

    private class HandleReportRequestHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        private HandleReportRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)98);
            MessageSeverity severity = Enum.valueOf(MessageSeverity.class, input.readUTF());
            ProtocolUtils.expectHeader((DataInput)input, (int)99);
            String message = input.readUTF();
            ProtocolUtils.expectHeader((DataInput)input, (int)21);
            ExecuteRequestContext requestContext = (ExecuteRequestContext)context.getAttachment();
            OperationMessageHandler handler = requestContext.getMessageHandler();
            handler.handleReport(severity, message);
        }
    }

    private class ExecuteRequest
    extends AbstractManagementRequest<Void, ExecuteRequestContext> {
        private ExecuteRequest() {
        }

        public byte getOperationType() {
            return 71;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
            ExecuteRequestContext executionContext = (ExecuteRequestContext)context.getAttachment();
            List<InputStream> streams = executionContext.getInputStreams();
            ModelNode operation = executionContext.getOperation();
            int inputStreamLength = 0;
            if (streams != null) {
                inputStreamLength = streams.size();
            }
            output.write(97);
            operation.writeExternal((DataOutput)output);
            output.write(101);
            output.writeInt(inputStreamLength);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
        }
    }
}

