/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.remote.AbstractModelControllerOperationHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;

public class TransactionalModelControllerOperationHandler
extends AbstractModelControllerOperationHandler<Void, ExecuteRequestContext> {
    private final ModelController controller;

    public TransactionalModelControllerOperationHandler(ModelController controller, ExecutorService executorService) {
        super(executorService);
        this.controller = controller;
    }

    protected ManagementRequestHeader validateRequest(ManagementProtocolHeader header) throws IOException {
        ManagementRequestHeader request = super.validateRequest(header);
        if (request.getOperationId() == 71) {
            ExecuteRequestContext executeRequestContext = new ExecuteRequestContext();
            ActiveOperation support = this.registerActiveOperation(request.getBatchId(), executeRequestContext);
            executeRequestContext.setActiveOperation((ActiveOperation<Void, ExecuteRequestContext>)support);
        } else if (request.getOperationId() == 79) {
            this.registerActiveOperation(request.getBatchId(), new ExecuteRequestContext());
        }
        return request;
    }

    protected ManagementRequestHandler<Void, ExecuteRequestContext> getRequestHandler(byte operationType) {
        switch (operationType) {
            case 71: {
                return new ExecuteRequestHandler();
            }
            case 78: {
                return new CompleteTxOperationHandler();
            }
            case 79: {
                return new LegacyMasterHcPingRequestHandler();
            }
        }
        return super.getRequestHandler(operationType);
    }

    static class ExecuteRequestContext {
        private ModelController.OperationTransaction activeTx;
        private ActiveOperation<Void, ExecuteRequestContext> operation;
        private final CountDownLatch txCompletedLatch = new CountDownLatch(1);

        ExecuteRequestContext() {
        }

        synchronized void setActiveOperation(ActiveOperation<Void, ExecuteRequestContext> operation) {
            assert (operation != null);
            this.operation = operation;
        }

        synchronized void setActiveTX(ModelController.OperationTransaction activeTx) {
            this.activeTx = activeTx;
        }

        synchronized void completeTx(boolean commit) {
            if (commit) {
                this.activeTx.commit();
            } else {
                this.activeTx.rollback();
            }
            this.txCompletedLatch.countDown();
        }

        synchronized ActiveOperation.ResultHandler<Void> getResultHandler() {
            return this.operation.getResultHandler();
        }

        synchronized Integer getBatchId() {
            return this.operation.getOperationId();
        }

        void handleFailed(Exception e) {
            this.getResultHandler().failed(e);
            this.txCompletedLatch.countDown();
        }

        void awaitTxCompleted() throws InterruptedException {
            this.txCompletedLatch.await();
        }
    }

    abstract class OperationStatusRequest
    extends AbstractManagementRequest<Void, ExecuteRequestContext> {
        private final ModelNode response;

        protected OperationStatusRequest(ModelNode response) {
            this.response = response;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
            output.write(100);
            this.response.writeExternal((DataOutput)output);
        }
    }

    private class ProxyOperationControlProxy
    implements ProxyController.ProxyOperationControl {
        private final int batchId;
        private final Channel channel;
        private final ExecuteRequestContext executeRequestContext;

        public ProxyOperationControlProxy(Channel channel, int batchId, ExecuteRequestContext executeRequestContext) {
            this.batchId = batchId;
            this.channel = channel;
            this.executeRequestContext = executeRequestContext;
        }

        @Override
        public void operationPrepared(final ModelController.OperationTransaction transaction, ModelNode result) {
            try {
                this.executeRequest((ManagementRequest<Void, ExecuteRequestContext>)new OperationStatusRequest(result){

                    public byte getOperationType() {
                        return 75;
                    }

                    @Override
                    protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context, FlushableDataOutput output) throws IOException {
                        ProxyOperationControlProxy.this.executeRequestContext.setActiveTX(transaction);
                        super.sendRequest(resultHandler, context, output);
                    }

                    public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
                    }
                });
            }
            catch (Exception e) {
                this.executeRequestContext.handleFailed(e);
                throw new RuntimeException(e);
            }
            try {
                this.executeRequestContext.awaitTxCompleted();
            }
            catch (InterruptedException e) {
                this.executeRequestContext.handleFailed(e);
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void operationFailed(ModelNode response) {
            this.executeRequest((ManagementRequest<Void, ExecuteRequestContext>)new OperationStatusRequest(response){

                public byte getOperationType() {
                    return 73;
                }

                public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
                    ProxyOperationControlProxy.this.executeRequestContext.getResultHandler().done(null);
                }
            });
        }

        @Override
        public void operationCompleted(ModelNode response) {
            this.executeRequest((ManagementRequest<Void, ExecuteRequestContext>)new OperationStatusRequest(response){

                public byte getOperationType() {
                    return 74;
                }

                public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
                    ProxyOperationControlProxy.this.executeRequestContext.getResultHandler().done(null);
                }
            });
        }

        protected void executeRequest(ManagementRequest<Void, ExecuteRequestContext> request) {
            try {
                this.executeRequest(this.channel, this.batchId, request);
            }
            catch (Exception e) {
                this.executeRequestContext.handleFailed(e);
            }
        }

        protected Future<Void> executeRequest(Channel channel, int batchId, ManagementRequest<Void, ExecuteRequestContext> request) {
            ActiveOperation support = TransactionalModelControllerOperationHandler.this.getActiveOperation(batchId);
            if (support == null) {
                throw ControllerMessages.MESSAGES.noActiveTransaction(batchId);
            }
            return TransactionalModelControllerOperationHandler.this.executeRequest(request, channel, support);
        }
    }

    private class CompleteTxOperationHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        private CompleteTxOperationHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            byte commitOrRollback = input.readByte();
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            executeRequestContext.completeTx(commitOrRollback == 112);
            context.executeAsync(ProtocolUtils.emptyResponseTask());
        }
    }

    private class ExecuteRequestHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        private ExecuteRequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            final ModelNode operation = new ModelNode();
            ProtocolUtils.expectHeader((DataInput)input, (int)97);
            operation.readExternal(input);
            ProtocolUtils.expectHeader((DataInput)input, (int)101);
            final int attachmentsLength = input.readInt();
            ManagementResponseHeader response = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
            FlushableDataOutput os = context.writeMessage((ManagementProtocolHeader)response);
            try {
                os.write(36);
                os.close();
            }
            finally {
                StreamUtils.safeClose((Closeable)os);
            }
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<ExecuteRequestContext>(){

                public void execute(ManagementRequestContext<ExecuteRequestContext> context) throws Exception {
                    ExecuteRequestHandler.this.doExecute(operation, attachmentsLength, context);
                }
            });
        }

        protected void doExecute(ModelNode operation, int attachmentsLength, ManagementRequestContext<ExecuteRequestContext> context) {
            ModelNode result;
            ExecuteRequestContext executeRequestContext = (ExecuteRequestContext)context.getAttachment();
            Integer batchId = executeRequestContext.getBatchId();
            AbstractModelControllerOperationHandler.OperationMessageHandlerProxy messageHandlerProxy = new AbstractModelControllerOperationHandler.OperationMessageHandlerProxy(context.getChannel(), batchId);
            ProxyOperationControlProxy control = new ProxyOperationControlProxy(context.getChannel(), batchId, executeRequestContext);
            AbstractModelControllerOperationHandler.OperationAttachmentsProxy attachmentsProxy = new AbstractModelControllerOperationHandler.OperationAttachmentsProxy(context.getChannel(), batchId, attachmentsLength);
            try {
                result = TransactionalModelControllerOperationHandler.this.controller.execute(operation, messageHandlerProxy, control, attachmentsProxy);
            }
            catch (Exception e) {
                ModelNode failure = new ModelNode();
                failure.get("outcome").set("failed");
                failure.get("failure-description").set(e.getClass().getName() + ":" + e.getMessage());
                control.operationFailed(failure);
                attachmentsProxy.shutdown(e);
                return;
            }
            if (result.hasDefined("failure-description")) {
                control.operationFailed(result);
            } else {
                control.operationCompleted(result);
            }
        }
    }

    private static class LegacyMasterHcPingRequestHandler
    implements ManagementRequestHandler<Void, ExecuteRequestContext> {
        private LegacyMasterHcPingRequestHandler() {
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<ExecuteRequestContext> context) throws IOException {
            context.executeAsync(ProtocolUtils.emptyResponseTask());
            resultHandler.done(null);
        }
    }
}

