/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.common.InterfaceDescription;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public final class InterfaceCriteriaWriteHandler
implements OperationStepHandler {
    public static final OperationStepHandler INSTANCE = new InterfaceCriteriaWriteHandler();
    private static final Map<String, AttributeDefinition> ATTRIBUTES = new HashMap<String, AttributeDefinition>();
    private static final OperationStepHandler VERIFY_HANDLER = new ModelValidationStep();

    public static void register(ManagementResourceRegistration registration) {
        for (AttributeDefinition def : InterfaceDescription.ROOT_ATTRIBUTES) {
            registration.registerReadWriteAttribute(def, null, INSTANCE);
        }
    }

    private InterfaceCriteriaWriteHandler() {
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = resource.getModel();
        String name = operation.require("name").asString();
        AttributeDefinition def = ATTRIBUTES.get(name);
        if (def == null) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.unknownAttribute(name)));
        }
        ModelNode value = operation.get("value");
        def.getValidator().validateParameter(name, value);
        model.get(name).set(value);
        context.reloadRequired();
        context.addStep(VERIFY_HANDLER, OperationContext.Stage.VERIFY);
        if (context.completeStep() != OperationContext.ResultAction.KEEP) {
            context.revertReloadRequired();
        }
    }

    static {
        for (AttributeDefinition def : InterfaceDescription.ROOT_ATTRIBUTES) {
            ATTRIBUTES.put(def.getName(), def);
        }
    }

    static class ModelValidationStep
    implements OperationStepHandler {
        ModelValidationStep() {
        }

        @Override
        public void execute(OperationContext context, ModelNode ignored) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            ModelNode model = resource.getModel();
            for (AttributeDefinition definition : InterfaceDescription.ROOT_ATTRIBUTES) {
                String attributeName = definition.getName();
                boolean has = model.hasDefined(attributeName);
                if (!has && this.isRequired(definition, model)) {
                    throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.required(attributeName)));
                }
                if (!has || this.isAllowed(definition, model)) continue;
                String[] alts = definition.getAlternatives();
                StringBuilder sb = null;
                if (alts != null) {
                    for (String alt : alts) {
                        if (!model.hasDefined(alt)) continue;
                        if (sb == null) {
                            sb = new StringBuilder();
                        } else {
                            sb.append(", ");
                        }
                        sb.append(alt);
                    }
                }
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.invalidAttributeCombo(attributeName, sb)));
            }
            context.completeStep();
        }

        boolean isRequired(AttributeDefinition def, ModelNode model) {
            boolean required;
            boolean bl = required = !def.isAllowNull();
            return required ? !this.hasAlternative(def.getAlternatives(), model) : required;
        }

        boolean isAllowed(AttributeDefinition def, ModelNode model) {
            String[] alternatives = def.getAlternatives();
            if (alternatives != null) {
                for (String alternative : alternatives) {
                    if (!model.hasDefined(alternative)) continue;
                    return false;
                }
            }
            return true;
        }

        boolean hasAlternative(String[] alternatives, ModelNode operationObject) {
            if (alternatives != null) {
                for (String alternative : alternatives) {
                    if (!operationObject.hasDefined(alternative)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

