/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.FilePersistenceResource;
import org.jboss.as.controller.persistence.ModelMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLMapper;

public class XmlConfigurationPersister
extends AbstractConfigurationPersister {
    private final File fileName;
    private final QName rootElement;
    private final XMLElementReader<List<ModelNode>> rootParser;
    private QName additionalRootElement;
    private XMLElementReader<List<ModelNode>> additionalParser;

    public XmlConfigurationPersister(File fileName, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser) {
        super(rootDeparser);
        this.fileName = fileName;
        this.rootElement = rootElement;
        this.rootParser = rootParser;
    }

    public void registerAdditionalRootElement(QName anotherRoot, XMLElementReader<List<ModelNode>> parser) {
        this.additionalRootElement = anotherRoot;
        this.additionalParser = parser;
    }

    @Override
    public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        return new FilePersistenceResource(model, this.fileName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store(ModelNode model, File file) throws ConfigurationPersistenceException {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                BufferedOutputStream output = new BufferedOutputStream(fos);
                this.marshallAsXml(model, output);
                output.close();
                fos.close();
            }
            finally {
                XmlConfigurationPersister.safeClose(fos);
            }
        }
        catch (Exception e) {
            throw ControllerMessages.MESSAGES.failedToStoreConfiguration(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModelNode> load() throws ConfigurationPersistenceException {
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.registerRootElement(this.rootElement, this.rootParser);
        if (this.additionalRootElement != null) {
            mapper.registerRootElement(this.additionalRootElement, this.additionalParser);
        }
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        try {
            FileInputStream fis = new FileInputStream(this.fileName);
            try {
                BufferedInputStream input = new BufferedInputStream(fis);
                XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
                mapper.parseDocument(updates, streamReader);
                streamReader.close();
                input.close();
                fis.close();
            }
            finally {
                XmlConfigurationPersister.safeClose(fis);
            }
        }
        catch (Exception e) {
            throw ControllerMessages.MESSAGES.failedToParseConfiguration(e);
        }
        return updates;
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                ControllerLogger.ROOT_LOGGER.failedToCloseResource(t, closeable);
            }
        }
    }

    protected void successfulBoot(File file) throws ConfigurationPersistenceException {
    }

    @Override
    public String snapshot() throws ConfigurationPersistenceException {
        return "";
    }
}

