/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.EnumSet;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SimpleAttributeDefinitionBuilder {
    private final String name;
    private final ModelType type;
    private String xmlName;
    private boolean allowNull;
    private boolean allowExpression;
    private ModelNode defaultValue;
    private MeasurementUnit measurementUnit;
    private String[] alternatives;
    private String[] requires;
    private ParameterValidator validator;
    private AttributeAccess.Flag[] flags;

    public static SimpleAttributeDefinitionBuilder create(String name, ModelType type) {
        return new SimpleAttributeDefinitionBuilder(name, type);
    }

    public static SimpleAttributeDefinitionBuilder create(String name, ModelType type, boolean allowNull) {
        return new SimpleAttributeDefinitionBuilder(name, type, allowNull);
    }

    public SimpleAttributeDefinitionBuilder(String attributeName, ModelType type) {
        this(attributeName, type, false);
    }

    public SimpleAttributeDefinitionBuilder(String attributeName, ModelType type, boolean allowNull) {
        this.name = attributeName;
        this.type = type;
        this.allowNull = allowNull;
        this.xmlName = this.name;
    }

    public SimpleAttributeDefinitionBuilder(SimpleAttributeDefinition basis) {
        this.name = basis.getName();
        this.type = basis.getType();
        this.xmlName = basis.getXmlName();
        this.allowNull = basis.isAllowNull();
        this.allowExpression = basis.isAllowExpression();
        this.defaultValue = basis.getDefaultValue();
        this.measurementUnit = basis.getMeasurementUnit();
        this.alternatives = basis.getAlternatives();
        this.requires = basis.getRequires();
        this.validator = basis.getValidator();
        EnumSet<AttributeAccess.Flag> basisFlags = basis.getFlags();
        this.flags = basisFlags.toArray(new AttributeAccess.Flag[basisFlags.size()]);
    }

    public SimpleAttributeDefinition build() {
        return new SimpleAttributeDefinition(this.name, this.xmlName, this.defaultValue, this.type, this.allowNull, this.allowExpression, this.measurementUnit, this.validator, this.alternatives, this.requires, this.flags);
    }

    public SimpleAttributeDefinitionBuilder setXmlName(String xmlName) {
        this.xmlName = xmlName == null ? this.name : xmlName;
        return this;
    }

    public SimpleAttributeDefinitionBuilder setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
        return this;
    }

    public SimpleAttributeDefinitionBuilder setAllowExpression(boolean allowExpression) {
        this.allowExpression = allowExpression;
        return this;
    }

    public SimpleAttributeDefinitionBuilder setDefaultValue(ModelNode defaultValue) {
        this.defaultValue = defaultValue == null || !defaultValue.isDefined() ? null : defaultValue;
        return this;
    }

    public SimpleAttributeDefinitionBuilder setMeasurementUnit(MeasurementUnit unit) {
        this.measurementUnit = unit;
        return this;
    }

    public SimpleAttributeDefinitionBuilder setValidator(ParameterValidator validator) {
        this.validator = validator;
        return this;
    }

    public SimpleAttributeDefinitionBuilder setAlternatives(String ... alternatives) {
        this.alternatives = alternatives;
        return this;
    }

    public SimpleAttributeDefinitionBuilder addAlternatives(String ... alternatives) {
        if (this.alternatives == null) {
            this.alternatives = alternatives;
        } else {
            String[] newAlternatives = Arrays.copyOf(this.alternatives, this.alternatives.length + alternatives.length);
            System.arraycopy(alternatives, 0, newAlternatives, this.alternatives.length, alternatives.length);
            this.alternatives = newAlternatives;
        }
        return this;
    }

    public SimpleAttributeDefinitionBuilder setRequires(String ... requires) {
        this.requires = requires;
        return this;
    }

    public SimpleAttributeDefinitionBuilder setFlags(AttributeAccess.Flag ... flags) {
        this.flags = flags;
        return this;
    }

    public SimpleAttributeDefinitionBuilder addFlag(AttributeAccess.Flag flag) {
        if (this.flags == null) {
            this.flags = new AttributeAccess.Flag[]{flag};
        } else {
            int i = this.flags.length;
            this.flags = Arrays.copyOf(this.flags, i + 1);
            this.flags[i] = flag;
        }
        return this;
    }

    public SimpleAttributeDefinitionBuilder removeFlag(AttributeAccess.Flag flag) {
        if (this.flags != null && this.flags.length > 0) {
            int length = this.flags.length;
            AttributeAccess.Flag[] newFlags = new AttributeAccess.Flag[length - 1];
            int k = 0;
            for (int i = 0; i < length; ++i) {
                if (this.flags[i] == flag) continue;
                newFlags[k] = this.flags[i];
                ++k;
            }
            if (k != length - 1) {
                this.flags = newFlags;
            }
        }
        return this;
    }

    public SimpleAttributeDefinitionBuilder setStorageRuntime() {
        this.removeFlag(AttributeAccess.Flag.STORAGE_CONFIGURATION);
        return this.addFlag(AttributeAccess.Flag.STORAGE_RUNTIME);
    }

    public SimpleAttributeDefinitionBuilder setRestartAllServices() {
        this.removeFlag(AttributeAccess.Flag.RESTART_NONE);
        this.removeFlag(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES);
        this.removeFlag(AttributeAccess.Flag.RESTART_JVM);
        return this.addFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES);
    }

    public SimpleAttributeDefinitionBuilder setRestartJVM() {
        this.removeFlag(AttributeAccess.Flag.RESTART_NONE);
        this.removeFlag(AttributeAccess.Flag.RESTART_RESOURCE_SERVICES);
        this.removeFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES);
        return this.addFlag(AttributeAccess.Flag.RESTART_JVM);
    }
}

