/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.as.controller.Cancellable;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.TransactionalModelController;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestConnectionStrategy;
import org.jboss.dmr.ModelNode;

abstract class AbstractModelControllerClient
implements TransactionalModelController {
    final byte handlerId;
    final ThreadFactory threadFactory = Executors.defaultThreadFactory();
    final ExecutorService executorService = Executors.newCachedThreadPool(this.threadFactory);

    public AbstractModelControllerClient(byte handlerId) {
        this.handlerId = handlerId;
    }

    @Override
    public OperationResult execute(final Operation operation, final ResultHandler handler) {
        if (operation == null) {
            throw new IllegalArgumentException("Null operation");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Null handler");
        }
        final AsynchronousOperation result = new AsynchronousOperation();
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Future f = new ExecuteAsynchronousRequest(result, operation, handler).execute(AbstractModelControllerClient.this.getConnectionStrategy());
                    while (true) {
                        try {
                            f.get(500L, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException e) {
                            if (!AbstractModelControllerClient.this.executorService.isShutdown()) continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to execute operation ", e);
                }
            }
        });
        return new OperationResult(){

            @Override
            public Cancellable getCancellable() {
                return result;
            }

            @Override
            public ModelNode getCompensatingOperation() {
                return null;
            }
        };
    }

    @Override
    public ModelNode execute(Operation operation) throws CancellationException {
        if (operation == null) {
            throw new IllegalArgumentException("Null operation");
        }
        try {
            return (ModelNode)new ExecuteSynchronousRequest(operation).executeForResult(this.getConnectionStrategy());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CancellationException) {
                throw new CancellationException(e.getCause().getMessage());
            }
            throw new RuntimeException("Failed to execute operation ", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute operation ", e);
        }
    }

    public void close() throws IOException {
        this.executorService.shutdown();
    }

    abstract ManagementRequestConnectionStrategy getConnectionStrategy();

    private ModelNode readNode(InputStream in) throws IOException {
        ModelNode node = new ModelNode();
        node.readExternal(in);
        return node;
    }

    private static class SimpleFuture<V>
    implements Future<V> {
        private V value;
        private volatile boolean done;
        private final Lock lock = new ReentrantLock();
        private final Condition hasValue = this.lock.newCondition();

        private SimpleFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() throws InterruptedException, ExecutionException {
            this.lock.lock();
            try {
                while (!this.done) {
                    this.hasValue.await();
                }
                V v = this.value;
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long deadline = unit.toMillis(timeout) + System.currentTimeMillis();
            this.lock.lock();
            try {
                while (!this.done) {
                    long remaining = deadline - System.currentTimeMillis();
                    if (remaining <= 0L) {
                        throw new TimeoutException();
                    }
                    this.hasValue.await(remaining, TimeUnit.MILLISECONDS);
                }
                V v = this.value;
                return v;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(V value) {
            this.lock.lock();
            try {
                this.value = value;
                this.done = true;
                this.hasValue.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private class AsynchronousOperation
    implements Cancellable {
        SimpleFuture<Integer> asynchronousId = new SimpleFuture();

        private AsynchronousOperation() {
        }

        @Override
        public boolean cancel() {
            try {
                int i = this.asynchronousId.get();
                if (i >= 0) {
                    return (Boolean)new CancelAsynchronousOperationRequest(i).executeForResult(AbstractModelControllerClient.this.getConnectionStrategy());
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not cancel request ", e);
            }
        }

        void setAsynchronousId(int i) {
            this.asynchronousId.set(i);
        }
    }

    private class CancelAsynchronousOperationRequest
    extends ModelControllerRequest<Boolean> {
        private final int asynchronousId;

        CancelAsynchronousOperationRequest(int asynchronousId) {
            this.asynchronousId = asynchronousId;
        }

        protected byte getRequestCode() {
            return 73;
        }

        protected byte getResponseCode() {
            return 80;
        }

        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            output.write(102);
            StreamUtils.writeInt((OutputStream)output, (int)this.asynchronousId);
        }

        protected Boolean receiveResponse(InputStream input) throws IOException {
            return StreamUtils.readBoolean((InputStream)input);
        }
    }

    private class ExecuteAsynchronousRequest
    extends ExecuteRequest<Void> {
        private final AsynchronousOperation result;
        private final ResultHandler handler;

        ExecuteAsynchronousRequest(AsynchronousOperation result, Operation operation, ResultHandler handler) {
            super(operation);
            this.result = result;
            this.handler = handler;
        }

        protected byte getRequestCode() {
            return 69;
        }

        protected byte getResponseCode() {
            return 70;
        }

        protected Void receiveResponse(InputStream input) throws IOException {
            block11: {
                try {
                    while (true) {
                        int command = input.read();
                        switch (command) {
                            case 99: {
                                ProtocolUtils.expectHeader((InputStream)input, (int)98);
                                int length = StreamUtils.readInt((InputStream)input);
                                String[] location = new String[length];
                                for (int i = 0; i < length; ++i) {
                                    location[i] = StreamUtils.readUTFZBytes((InputStream)input);
                                }
                                ProtocolUtils.expectHeader((InputStream)input, (int)96);
                                ModelNode node = AbstractModelControllerClient.this.readNode(input);
                                this.handler.handleResultFragment(location, node);
                                break;
                            }
                            case 101: {
                                this.handler.handleCancellation();
                                break block11;
                            }
                            case 103: {
                                ProtocolUtils.expectHeader((InputStream)input, (int)96);
                                ModelNode node = AbstractModelControllerClient.this.readNode(input);
                                this.handler.handleFailed(node);
                                break block11;
                            }
                            case 100: {
                                ProtocolUtils.expectHeader((InputStream)input, (int)96);
                                ModelNode node = AbstractModelControllerClient.this.readNode(input);
                                this.handler.handleResultComplete();
                                break block11;
                            }
                            case 102: {
                                this.result.setAsynchronousId(StreamUtils.readInt((InputStream)input));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown response code " + command);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.handler.handleFailed(new ModelNode().set(e.toString()));
                }
            }
            return null;
        }
    }

    private class ExecuteSynchronousRequest
    extends ExecuteRequest<ModelNode> {
        ExecuteSynchronousRequest(Operation operation) {
            super(operation);
        }

        protected byte getRequestCode() {
            return 71;
        }

        protected byte getResponseCode() {
            return 72;
        }

        protected ModelNode receiveResponse(InputStream input) throws IOException {
            ProtocolUtils.expectHeader((InputStream)input, (int)96);
            return AbstractModelControllerClient.this.readNode(input);
        }
    }

    private abstract class ExecuteRequest<T>
    extends ModelControllerRequest<T> {
        private final Operation operation;

        public ExecuteRequest(Operation executionContext) {
            this.operation = executionContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendRequest(int protocolVersion, OutputStream output) throws IOException {
            output.write(96);
            this.operation.getOperation().writeExternal(output);
            List streams = this.operation.getInputStreams();
            for (InputStream in : streams) {
                output.write(104);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                try {
                    int read;
                    byte[] buffer = new byte[8192];
                    while ((read = in.read(buffer)) != -1) {
                        bout.write(buffer, 0, read);
                    }
                }
                finally {
                    StreamUtils.safeClose((Closeable)in);
                }
                byte[] bytes = bout.toByteArray();
                StreamUtils.writeInt((OutputStream)output, (int)bytes.length);
                try {
                    for (byte b : bytes) {
                        output.write(b);
                    }
                }
                finally {
                    StreamUtils.safeClose((Closeable)in);
                }
            }
            output.write(105);
        }
    }

    private abstract class ModelControllerRequest<T>
    extends ManagementRequest<T> {
        private ModelControllerRequest() {
        }

        protected byte getHandlerId() {
            return AbstractModelControllerClient.this.handlerId;
        }
    }
}

