/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.impl.AbstractModelControllerClient;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public interface ModelControllerClient
extends Closeable {
    public ModelNode execute(ModelNode var1) throws IOException;

    public ModelNode execute(Operation var1) throws IOException;

    public ModelNode execute(ModelNode var1, OperationMessageHandler var2) throws IOException;

    public ModelNode execute(Operation var1, OperationMessageHandler var2) throws IOException;

    public AsyncFuture<ModelNode> executeAsync(ModelNode var1, OperationMessageHandler var2);

    public AsyncFuture<ModelNode> executeAsync(Operation var1, OperationMessageHandler var2);

    public static class Factory {
        public static ModelControllerClient create(final InetAddress address, final int port) {
            return new AbstractModelControllerClient(){

                @Override
                protected ManagementClientChannelStrategy getClientChannelStrategy() throws URISyntaxException, IOException {
                    return ManagementClientChannelStrategy.create((String)address.getHostName(), (int)port, (ExecutorService)this.executor, (ManagementOperationHandler)this, null);
                }
            };
        }

        public static ModelControllerClient create(final InetAddress address, final int port, final CallbackHandler handler) {
            return new AbstractModelControllerClient(){

                @Override
                protected ManagementClientChannelStrategy getClientChannelStrategy() throws URISyntaxException, IOException {
                    return ManagementClientChannelStrategy.create((String)address.getHostName(), (int)port, (ExecutorService)this.executor, (ManagementOperationHandler)this, (CallbackHandler)handler);
                }
            };
        }

        public static ModelControllerClient create(final String hostName, final int port) throws UnknownHostException {
            return new AbstractModelControllerClient(){

                @Override
                protected ManagementClientChannelStrategy getClientChannelStrategy() throws URISyntaxException, IOException {
                    return ManagementClientChannelStrategy.create((String)hostName, (int)port, (ExecutorService)this.executor, (ManagementOperationHandler)this, null);
                }
            };
        }

        public static ModelControllerClient create(final String hostName, final int port, final CallbackHandler handler) throws UnknownHostException {
            return new AbstractModelControllerClient(){

                @Override
                protected ManagementClientChannelStrategy getClientChannelStrategy() throws URISyntaxException, IOException {
                    return ManagementClientChannelStrategy.create((String)hostName, (int)port, (ExecutorService)this.executor, (ManagementOperationHandler)this, (CallbackHandler)handler);
                }
            };
        }
    }
}

