/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.standalone.impl;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.standalone.ServerUpdateActionResult;
import org.jboss.as.controller.client.helpers.standalone.SimpleServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.impl.DeploymentActionImpl;
import org.jboss.as.controller.client.helpers.standalone.impl.DeploymentPlanImpl;
import org.jboss.as.controller.client.helpers.standalone.impl.DeploymentPlanResultImpl;
import org.jboss.dmr.ModelNode;

class ServerDeploymentPlanResultFuture
implements Future<ServerDeploymentPlanResult> {
    private final Future<ModelNode> nodeFuture;
    private final DeploymentPlanImpl plan;

    ServerDeploymentPlanResultFuture(DeploymentPlanImpl plan, Future<ModelNode> nodeFuture) {
        this.plan = plan;
        this.nodeFuture = nodeFuture;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.nodeFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.nodeFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.nodeFuture.isDone();
    }

    @Override
    public ServerDeploymentPlanResult get() throws InterruptedException, ExecutionException {
        ModelNode node = this.nodeFuture.get();
        return this.getResultFromNode(node);
    }

    @Override
    public ServerDeploymentPlanResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ModelNode node = this.nodeFuture.get(timeout, unit);
        return this.getResultFromNode(node);
    }

    private ServerDeploymentPlanResult getResultFromNode(ModelNode planResultNode) {
        UUID planId = this.plan.getId();
        HashMap<UUID, ServerDeploymentActionResult> actionResults = new HashMap<UUID, ServerDeploymentActionResult>();
        List<DeploymentActionImpl> actions = this.plan.getDeploymentActionImpls();
        for (int i = 0; i < actions.size(); ++i) {
            DeploymentActionImpl action = actions.get(i);
            UUID actionId = action.getId();
            ModelNode actionResultNode = planResultNode.get("step-" + i);
            actionResults.put(actionId, this.getActionResult(actionId, actionResultNode));
        }
        return new DeploymentPlanResultImpl(planId, actionResults);
    }

    private ServerDeploymentActionResult getActionResult(UUID actionId, ModelNode actionResultNode) {
        SimpleServerDeploymentActionResult actionResult = null;
        String outcome = actionResultNode.get("outcome").asString();
        if ("cancelled".equals(outcome)) {
            actionResult = new SimpleServerDeploymentActionResult(actionId, ServerUpdateActionResult.Result.NOT_EXECUTED);
        } else if ("failed".equals(outcome)) {
            Exception e;
            Exception exception = e = actionResultNode.hasDefined("failure-description") ? new Exception(actionResultNode.get("failure-description").toString()) : null;
            actionResult = actionResultNode.hasDefined("rolled-back") && actionResultNode.get("rolled-back").asBoolean() ? (e == null ? new SimpleServerDeploymentActionResult(actionId, ServerUpdateActionResult.Result.ROLLED_BACK) : new SimpleServerDeploymentActionResult(actionId, ServerUpdateActionResult.Result.ROLLED_BACK, e)) : new SimpleServerDeploymentActionResult(actionId, e);
        } else {
            actionResult = new SimpleServerDeploymentActionResult(actionId, ServerUpdateActionResult.Result.EXECUTED);
        }
        return actionResult;
    }
}

