/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.InputStream;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationImpl;
import org.jboss.dmr.ModelNode;

public interface OperationBuilder {
    public OperationBuilder addInputStream(InputStream var1);

    public int getInputStreamCount();

    public Operation build();

    public static class Factory {
        public static OperationBuilder create(ModelNode operation) {
            if (operation == null) {
                throw new IllegalArgumentException("Null operation");
            }
            return new OperationImpl(operation);
        }

        public static OperationBuilder copy(OperationAttachments attachments, ModelNode operation) {
            if (operation == null) {
                throw new IllegalArgumentException("Null operation");
            }
            OperationImpl ctx = new OperationImpl(operation);
            for (InputStream in : attachments.getInputStreams()) {
                ctx.addInputStream(in);
            }
            return ctx;
        }
    }
}

