/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.parser;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.configadmin.ConfigAdminLogger;
import org.jboss.as.configadmin.parser.ConfigAdminProviders;
import org.jboss.as.configadmin.parser.ConfigAdminState;
import org.jboss.as.configadmin.service.ConfigAdminServiceImpl;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class ConfigAdminAdd
extends AbstractBoottimeAddStepHandler {
    static final ConfigAdminAdd INSTANCE = new ConfigAdminAdd();
    static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = ConfigAdminProviders.getResourceBundle(locale);
            node.get("operation-name").set("add");
            node.get("description").set(resbundle.getString("subsystem.add"));
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };

    private ConfigAdminAdd() {
    }

    static ModelNode createAddSubsystemOperation() {
        ModelNode addop = new ModelNode();
        addop.get("operation").set("add");
        addop.get("address").add("subsystem", "configadmin");
        return addop;
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) {
        ConfigAdminLogger.ROOT_LOGGER.activatingSubsystem();
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceTarget serviceTarget = context.getServiceTarget();
                newControllers.add(ConfigAdminServiceImpl.addService(serviceTarget, new ServiceListener[]{verificationHandler}));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        ServiceTarget serviceTarget = context.getServiceTarget();
        newControllers.add(ConfigAdminState.addService(serviceTarget));
        ConfigAdminLogger.ROOT_LOGGER.debugf("Activated ConfigAdmin Subsystem", new Object[0]);
    }
}

