/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.web.sso.infinispan;

import java.util.Map;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.jboss.as.clustering.infinispan.atomic.AtomicMapCache;
import org.jboss.as.clustering.infinispan.invoker.BatchOperation;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.web.sso.FullyQualifiedSessionId;
import org.jboss.as.clustering.web.sso.SSOCredentials;
import org.jboss.as.clustering.web.sso.SSOLocalManager;
import org.jboss.as.clustering.web.sso.infinispan.CredentialKey;
import org.jboss.as.clustering.web.sso.infinispan.SSOKey;
import org.jboss.as.clustering.web.sso.infinispan.SessionKey;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;

@Listener
public final class SSOClusterManager
implements org.jboss.as.clustering.web.sso.SSOClusterManager {
    private static final Logger log = Logger.getLogger(SSOClusterManager.class);
    private volatile Cache<SSOKey, Object> cache;
    private volatile Cache<CredentialKey, SSOCredentials> credentialCache;
    private volatile Cache<SessionKey, Map<FullyQualifiedSessionId, Void>> sessionCache;
    private final InjectedValue<Cache> cacheRef = new InjectedValue();
    private volatile String cacheContainerName = "web";
    private volatile String cacheName = "sso";
    private volatile SSOLocalManager ssoValve = null;

    public void addDependencies(ServiceTarget target, ServiceBuilder<?> builder) {
        builder.addDependency(CacheService.getServiceName((String)this.cacheContainerName, (String)this.cacheName), Cache.class, this.cacheRef);
    }

    public void setCacheContainerName(String cacheContainerName) {
        this.cacheContainerName = cacheContainerName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public void addSession(String ssoId, final FullyQualifiedSessionId sessionId) {
        this.trace("addSession(): adding Session %s to cached session set for SSO %s", sessionId.getSessionId(), ssoId);
        final SessionKey key = new SessionKey(ssoId);
        SessionOperation<Void> operation = new SessionOperation<Void>(){

            public Void invoke(Cache<SessionKey, Map<FullyQualifiedSessionId, Void>> cache) {
                ((Map)cache.putIfAbsent((Object)key, null)).put(sessionId, null);
                return null;
            }
        };
        this.batch(this.sessionCache, operation);
    }

    public SSOLocalManager getSSOLocalManager() {
        return this.ssoValve;
    }

    public void setSSOLocalManager(SSOLocalManager localManager) {
        this.ssoValve = localManager;
    }

    public void logout(final String ssoId) {
        this.trace("Registering logout of SSO %s in clustered cache", ssoId);
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<SSOKey, Object> cache) {
                AdvancedCache removeCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP});
                removeCache.remove((Object)new SessionKey(ssoId));
                removeCache.remove((Object)new CredentialKey(ssoId));
                return null;
            }
        };
        this.batch(this.cache, operation);
    }

    public SSOCredentials lookup(String ssoId) {
        return (SSOCredentials)this.credentialCache.get((Object)new CredentialKey(ssoId));
    }

    public void register(String ssoId, String authType, String username, String password) {
        this.trace("Registering SSO %s in clustered cache", ssoId);
        this.storeCredentials(ssoId, authType, username, password);
    }

    public void removeSession(String ssoId, final FullyQualifiedSessionId sessionId) {
        this.trace("removeSession(): removing Session %s from cached session set for SSO %s", sessionId.getSessionId(), ssoId);
        final SessionKey key = new SessionKey(ssoId);
        SessionOperation<Boolean> operation = new SessionOperation<Boolean>(){

            public Boolean invoke(Cache<SessionKey, Map<FullyQualifiedSessionId, Void>> cache) {
                Map sessions = (Map)cache.get((Object)key);
                if (sessions == null) {
                    return false;
                }
                sessions.remove(sessionId);
                return sessions.isEmpty();
            }
        };
        if (this.batch(this.sessionCache, operation).booleanValue()) {
            this.notifySSOEmpty(ssoId);
        }
    }

    public void updateCredentials(String ssoId, String authType, String username, String password) {
        this.trace("Updating credentials for SSO %s in clustered cache", ssoId);
        this.storeCredentials(ssoId, authType, username, password);
    }

    @CacheEntryRemoved
    public void cacheEntryRemoved(CacheEntryRemovedEvent<SSOKey, ?> event) {
        if (event.isPre()) {
            return;
        }
        SSOKey key = (SSOKey)event.getKey();
        String ssoId = key.getId();
        if (key instanceof SessionKey) {
            this.trace("cacheEntryRemoved ssoId = %s", ssoId);
            if (!event.isOriginLocal()) {
                this.ssoValve.deregister(key.getId());
            }
            this.ssoValve.notifySSOEmpty(ssoId);
        }
    }

    private boolean notifySSOEmpty(String ssoId) {
        boolean empty;
        SessionKey key = new SessionKey(ssoId);
        boolean bl = empty = this.sessionCache.containsKey((Object)key) ? ((Map)this.sessionCache.get((Object)key)).isEmpty() : true;
        if (empty) {
            this.ssoValve.notifySSOEmpty(ssoId);
        }
        return empty;
    }

    @CacheEntryModified
    public void cacheEntryModified(CacheEntryModifiedEvent<SSOKey, ?> event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        SSOKey key = (SSOKey)event.getKey();
        String ssoId = key.getId();
        if (key instanceof CredentialKey) {
            this.trace("received a credentials modified message for SSO %s", ssoId);
            SSOCredentials credentials = (SSOCredentials)event.getValue();
            if (credentials != null) {
                this.ssoValve.remoteUpdate(ssoId, credentials);
            }
        } else if (key instanceof SessionKey) {
            this.trace("received a session modified message for SSO %s", ssoId);
            if (!this.notifySSOEmpty(ssoId)) {
                this.ssoValve.notifySSONotEmpty(ssoId);
            }
        }
    }

    public void start() throws Exception {
        AdvancedCache cache;
        this.cache = cache = ((Cache)this.cacheRef.getValue()).getAdvancedCache();
        this.credentialCache = cache;
        this.sessionCache = new AtomicMapCache(cache);
        this.cache.addListener((Object)this);
    }

    public void stop() throws Exception {
        this.cache.removeListener((Object)this);
    }

    private void storeCredentials(final String ssoId, String authType, String username, String password) {
        final SSOCredentials credentials = new SSOCredentials(authType, username, password);
        CredentialOperation<Void> operation = new CredentialOperation<Void>(){

            public Void invoke(Cache<CredentialKey, SSOCredentials> cache) {
                cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put((Object)new CredentialKey(ssoId), (Object)credentials);
                return null;
            }
        };
        this.batch(this.credentialCache, operation);
    }

    <K extends SSOKey, V, R> R batch(Cache<K, V> cache, CacheInvoker.Operation<K, V, R> operation) {
        return (R)new BatchOperation(operation).invoke(cache);
    }

    private void trace(String message, Object ... args) {
        if (log.isTraceEnabled()) {
            log.tracef(message, args);
        }
    }

    abstract class SessionOperation<R>
    implements CacheInvoker.Operation<SessionKey, Map<FullyQualifiedSessionId, Void>, R> {
        SessionOperation() {
        }
    }

    abstract class CredentialOperation<R>
    implements CacheInvoker.Operation<CredentialKey, SSOCredentials, R> {
        CredentialOperation() {
        }
    }

    abstract class Operation<R>
    implements CacheInvoker.Operation<SSOKey, Object, R> {
        Operation() {
        }
    }
}

