/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.Mode;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class ClusteredCacheAdd
extends CacheAdd {
    public static SimpleAttributeDefinition MODE = new SimpleAttributeDefinitionBuilder("mode", ModelType.STRING, false).setXmlName(Attribute.MODE.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(Mode.class, true, false)).build();

    ClusteredCacheAdd(CacheMode mode) {
        super(mode);
    }

    void populateMode(ModelNode fromModel, ModelNode toModel) {
        toModel.get("mode").set(Mode.forCacheMode(CacheMode.valueOf((String)fromModel.get("mode").asString())).name());
    }

    @Override
    void populateCacheMode(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        toModel.get("mode").set(Mode.valueOf(fromModel.require("mode").asString()).apply(this.mode).name());
    }

    @Override
    void populate(ModelNode fromModel, ModelNode toModel) {
        super.populate(fromModel, toModel);
        if (fromModel.hasDefined("queue-size")) {
            toModel.get("queue-size").set(fromModel.get("queue-size"));
        }
        if (fromModel.hasDefined("queue-flush-interval")) {
            toModel.get("queue-flush-interval").set(fromModel.get("queue-flush-interval"));
        }
        if (fromModel.hasDefined("remote-timeout")) {
            toModel.get("remote-timeout").set(fromModel.get("remote-timeout"));
        }
    }

    @Override
    void processModelNode(String containerName, ModelNode cache, ConfigurationBuilder builder, List<CacheAdd.Dependency<?>> dependencies) {
        super.processModelNode(containerName, cache, builder, dependencies);
        if (CacheMode.valueOf((String)cache.get("mode").asString()).isSynchronous()) {
            if (cache.hasDefined("remote-timeout")) {
                builder.clustering().sync().replTimeout(cache.get("remote-timeout").asLong());
            }
        } else {
            if (cache.hasDefined("queue-size")) {
                builder.clustering().async().replQueueMaxElements(cache.get("queue-size").asInt());
            }
            if (cache.hasDefined("queue-flush-interval")) {
                builder.clustering().async().replQueueInterval(cache.get("queue-flush-interval").asLong());
            }
        }
    }
}

