/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.util.Properties;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelLookup;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jgroups.Channel;

public class ChannelProvider
implements JGroupsChannelLookup {
    private static final String CHANNEL_FACTORY = "channel-factory";
    private static final String ID = "id";

    public static void init(GlobalConfiguration global, ChannelFactory factory) {
        Properties properties = global.getTransportProperties();
        properties.setProperty("channelLookup", ChannelProvider.class.getName());
        properties.put(CHANNEL_FACTORY, factory);
        properties.put(ID, global.getTransportNodeName() + "-" + global.getClusterName());
    }

    public Channel getJGroupsChannel(Properties properties) {
        ChannelFactory factory = (ChannelFactory)properties.get(CHANNEL_FACTORY);
        if (factory == null) {
            throw new IllegalStateException(String.format("No %s property was specified within the transport properties: %s", CHANNEL_FACTORY, properties));
        }
        String id = properties.getProperty(ID);
        if (id == null) {
            throw new IllegalStateException(String.format("No %s property was specified within the transport properties: %s", ID, properties));
        }
        try {
            return factory.createChannel(id);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean shouldStartAndConnect() {
        return true;
    }

    public boolean shouldStopAndDisconnect() {
        return true;
    }
}

