/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentGlobalConfiguration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.jboss.as.clustering.infinispan.ChannelProvider;
import org.jboss.as.clustering.infinispan.DefaultEmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.ExecutorProvider;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.TransactionSynchronizationRegistryProvider;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaults;
import org.jboss.as.clustering.infinispan.subsystem.TransportConfiguration;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

@Listener
public class EmbeddedCacheManagerService
implements Service<CacheContainer> {
    private static final Logger log = Logger.getLogger((String)EmbeddedCacheManagerService.class.getPackage().getName());
    private static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"infinispan"});
    private final EmbeddedCacheManagerConfiguration configuration;
    private volatile CacheContainer container;

    public static ServiceName getServiceName(String name) {
        return name != null ? SERVICE_NAME.append(new String[]{name}) : SERVICE_NAME;
    }

    public EmbeddedCacheManagerService(EmbeddedCacheManagerConfiguration configuration) {
        this.configuration = configuration;
    }

    public CacheContainer getValue() throws IllegalStateException, IllegalArgumentException {
        return this.container;
    }

    public void start(StartContext context) throws StartException {
        TransactionSynchronizationRegistry transactionSynchronizationRegistry;
        ScheduledExecutorService replicationQueueExecutor;
        ScheduledExecutorService evictionExecutor;
        EmbeddedCacheManagerDefaults defaults = this.configuration.getDefaults();
        GlobalConfiguration global = defaults.getGlobalConfiguration().clone();
        TransportConfiguration transport = this.configuration.getTransportConfiguration();
        FluentGlobalConfiguration.TransportConfig fluentTransport = global.fluent().transport();
        if (transport != null) {
            String machine;
            String rack;
            String site;
            fluentTransport.transportClass(JGroupsTransport.class);
            Long timeout = transport.getLockTimeout();
            if (timeout != null) {
                fluentTransport.distributedSyncTimeout(Long.valueOf(timeout));
            }
            if ((site = transport.getSite()) != null) {
                fluentTransport.siteId(site);
            }
            if ((rack = transport.getRack()) != null) {
                fluentTransport.rackId(rack);
            }
            if ((machine = transport.getMachine()) != null) {
                fluentTransport.machineId(machine);
            }
            fluentTransport.nodeName(transport.getEnvironment().getNodeName());
            fluentTransport.clusterName(this.configuration.getName());
            ChannelProvider.init(global, transport.getChannelFactory());
            Executor executor = transport.getExecutor();
            if (executor != null) {
                ExecutorProvider.initTransportExecutor(global, executor);
            }
        } else {
            fluentTransport.transportClass(null);
        }
        FluentGlobalConfiguration.GlobalJmxStatisticsConfig globalJmx = fluentTransport.globalJmxStatistics();
        globalJmx.cacheManagerName(this.configuration.getName());
        MBeanServer server = this.configuration.getMBeanServer();
        if (server != null) {
            globalJmx.mBeanServerLookup((MBeanServerLookup)new MBeanServerProvider(server)).jmxDomain(server.getDefaultDomain());
        } else {
            globalJmx.disable();
        }
        Executor listenerExecutor = this.configuration.getListenerExecutor();
        if (listenerExecutor != null) {
            ExecutorProvider.initListenerExecutor(global, listenerExecutor);
        }
        if ((evictionExecutor = this.configuration.getEvictionExecutor()) != null) {
            ExecutorProvider.initEvictionExecutor(global, evictionExecutor);
        }
        if ((replicationQueueExecutor = this.configuration.getReplicationQueueExecutor()) != null) {
            ExecutorProvider.initReplicationQueueExecutor(global, replicationQueueExecutor);
        }
        Configuration defaultConfig = new Configuration();
        TransactionManager transactionManager = this.configuration.getTransactionManager();
        if (transactionManager != null) {
            defaultConfig.fluent().transaction().transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider(transactionManager));
        }
        if ((transactionSynchronizationRegistry = this.configuration.getTransactionSynchronizationRegistry()) != null) {
            defaultConfig.fluent().transaction().transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new TransactionSynchronizationRegistryProvider(transactionSynchronizationRegistry));
        }
        DefaultCacheManager manager = new DefaultCacheManager(global, defaultConfig, false);
        manager.addListener((Object)this);
        for (Map.Entry<String, Configuration> entry : this.configuration.getConfigurations().entrySet()) {
            Configuration overrides = entry.getValue();
            Configuration configuration = defaults.getDefaultConfiguration(overrides.getCacheMode()).clone();
            configuration.applyOverrides(overrides);
            manager.defineConfiguration(entry.getKey(), configuration);
        }
        this.container = new DefaultEmbeddedCacheManager((EmbeddedCacheManager)manager, this.configuration.getDefaultCache());
        this.container.start();
    }

    public void stop(StopContext context) {
        this.container.stop();
        this.container = null;
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        log.infof("Started %s cache from %s container", (Object)event.getCacheName(), (Object)event.getCacheManager().getGlobalConfiguration().getCacheManagerName());
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        String cacheName = event.getCacheName();
        EmbeddedCacheManager container = event.getCacheManager();
        GlobalConfiguration global = container.getGlobalConfiguration();
        String containerName = global.getCacheManagerName();
        log.infof("Stopped %s cache from %s container", (Object)cacheName, (Object)containerName);
        MBeanServer server = this.configuration.getMBeanServer();
        if (server != null) {
            Configuration configuration;
            Configuration configuration2 = configuration = cacheName.equals("___defaultcache") ? container.getDefaultConfiguration() : container.defineConfiguration(cacheName, new Configuration());
            if (configuration.isExposeJmxStatistics()) {
                String domain = global.getJmxDomain();
                String jmxCacheName = String.format("%s(%s)", cacheName, configuration.getCacheModeString().toLowerCase(Locale.ENGLISH));
                try {
                    ObjectName name = ObjectName.getInstance(String.format("%s:%s,%s=%s,manager=%s,%s=%s", domain, "type=Cache", ComponentsJmxRegistration.NAME_KEY, ObjectName.quote(jmxCacheName), ObjectName.quote(containerName), ComponentsJmxRegistration.COMPONENT_KEY, "Cache"));
                    if (server.isRegistered(name)) {
                        server.unregisterMBean(name);
                        log.tracef("Unregistered cache mbean: %s", (Object)name);
                    }
                }
                catch (JMException e) {
                    log.debugf((Throwable)e, "Failed to unregister mbean for %s cache", (Object)cacheName);
                }
            }
        }
    }
}

