/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class PropertyNameCompleter
extends DefaultCompleter {
    public PropertyNameCompleter(final OperationRequestAddress address, final boolean onlyWritable) {
        super(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                ModelNode response;
                ModelNode req = new ModelNode();
                ModelNode addrNode = req.get("address");
                for (OperationRequestAddress.Node node : address) {
                    addrNode.add(node.getType(), node.getName());
                }
                req.get("operation").set("read-resource-description");
                try {
                    response = ctx.getModelControllerClient().execute(req);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
                ModelNode result = response.get("result");
                if (!result.isDefined()) {
                    return Collections.emptyList();
                }
                ModelNode attrs = result.get("attributes");
                if (!attrs.isDefined()) {
                    return Collections.emptyList();
                }
                ArrayList<String> names = new ArrayList<String>();
                for (Property attr : attrs.asPropertyList()) {
                    if (onlyWritable) {
                        ModelNode descr = attr.getValue();
                        if (descr.has("access-type") && "read-only".equals(descr.get("access-type").asString())) continue;
                        names.add(attr.getName());
                        continue;
                    }
                    names.add(attr.getName());
                }
                return names;
            }
        });
    }
}

