/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.impl.CommandContextImpl;
import org.jboss.as.cli.impl.SecurityActions;

public class CommandContextFactoryImpl
extends CommandContextFactory {
    @Override
    public CommandContext newCommandContext() throws CliInitializationException {
        CommandContextImpl cmdCtx = new CommandContextImpl();
        this.addShutdownHook(cmdCtx);
        return cmdCtx;
    }

    @Override
    public CommandContext newCommandContext(String username, char[] password) throws CliInitializationException {
        CommandContextImpl cmdCtx = new CommandContextImpl(username, password);
        this.addShutdownHook(cmdCtx);
        return cmdCtx;
    }

    @Override
    public CommandContext newCommandContext(String controllerHost, int controllerPort, String username, char[] password) throws CliInitializationException {
        return this.newCommandContext(controllerHost, controllerPort, username, password, false);
    }

    @Override
    public CommandContext newCommandContext(String controllerHost, int controllerPort, String username, char[] password, boolean initConsole) throws CliInitializationException {
        CommandContextImpl ctx = new CommandContextImpl(controllerHost, controllerPort, username, password, initConsole);
        this.addShutdownHook(ctx);
        return ctx;
    }

    protected void addShutdownHook(final CommandContext cmdCtx) {
        SecurityActions.addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (!cmdCtx.isTerminated()) {
                    cmdCtx.terminateSession();
                }
                cmdCtx.disconnectController();
            }
        }));
    }
}

