/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.batch;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;

public class BatchMoveLineHandler
extends CommandHandlerWithHelp {
    public BatchMoveLineHandler() {
        super("batch-move-line");
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        if (!super.isAvailable(ctx)) {
            return false;
        }
        return ctx.isBatchMode();
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        int toLineNumber;
        int lineNumber;
        BatchManager batchManager = ctx.getBatchManager();
        if (!batchManager.isBatchActive()) {
            ctx.error("No active batch.");
            return;
        }
        Batch batch = batchManager.getActiveBatch();
        int batchSize = batch.size();
        if (batchSize == 0) {
            ctx.error("The batch is empty.");
            return;
        }
        List<String> arguments = ctx.getParsedCommandLine().getOtherProperties();
        if (arguments.isEmpty()) {
            ctx.error("Missing line number.");
            return;
        }
        if (arguments.size() != 2) {
            ctx.error("Expected two arguments but received: " + arguments);
            return;
        }
        String intStr = arguments.get(0);
        try {
            lineNumber = Integer.parseInt(intStr);
        }
        catch (NumberFormatException e) {
            ctx.error("Failed to parse line number '" + intStr + "': " + e.getLocalizedMessage());
            return;
        }
        if (lineNumber < 1 || lineNumber > batchSize) {
            ctx.error(lineNumber + " isn't in range [1.." + batchSize + "].");
            return;
        }
        intStr = arguments.get(1);
        try {
            toLineNumber = Integer.parseInt(intStr);
        }
        catch (NumberFormatException e) {
            ctx.error("Failed to parse line number '" + intStr + "': " + e.getLocalizedMessage());
            return;
        }
        if (toLineNumber < 1 || toLineNumber > batchSize) {
            ctx.error(toLineNumber + " isn't in range [1.." + batchSize + "].");
            return;
        }
        batch.move(lineNumber - 1, toLineNumber - 1);
    }

    @Override
    public boolean hasArgument(int index) {
        return index < 2;
    }
}

