/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class OperationRequestHandler
implements CommandHandler,
OperationCommand {
    @Override
    public boolean isBatchMode(CommandContext ctx) {
        return true;
    }

    @Override
    public void handle(CommandContext ctx) {
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            ctx.error("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
            return;
        }
        ModelNode request = (ModelNode)ctx.get("OP_REQ");
        if (request == null) {
            ctx.error("Parsed request isn't available.");
            return;
        }
        try {
            this.validateRequest(ctx, request);
        }
        catch (CommandFormatException e) {
            ctx.error(e.getLocalizedMessage());
            return;
        }
        try {
            ModelNode result = client.execute(request);
            ctx.printLine(result.toString());
        }
        catch (NoSuchElementException e) {
            ctx.error("ModelNode request is incomplete: " + e.getMessage());
        }
        catch (CancellationException e) {
            ctx.error("The result couldn't be retrieved (perhaps the task was cancelled: " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            ctx.error("Communication error: " + e.getLocalizedMessage());
            ctx.disconnectController();
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return true;
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        return ((DefaultCallbackHandler)ctx.getParsedCommandLine()).toOperationRequest(ctx);
    }

    @Override
    public boolean hasArgument(String name) {
        return false;
    }

    @Override
    public boolean hasArgument(int index) {
        return false;
    }

    public List<CommandArgument> getArguments(CommandContext ctx) {
        return Collections.emptyList();
    }

    private void validateRequest(CommandContext ctx, ModelNode request) throws CommandFormatException {
        ModelNode outcome;
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            throw new CommandFormatException("No connection to the controller.");
        }
        Set keys = request.keys();
        if (!keys.contains("operation")) {
            throw new CommandFormatException("Request is missing the operation name.");
        }
        String operationName = request.get("operation").asString();
        if (!keys.contains("address")) {
            throw new CommandFormatException("Request is missing the address part.");
        }
        ModelNode address = request.get("address");
        if (keys.size() == 2) {
            return;
        }
        ModelNode opDescrReq = new ModelNode();
        opDescrReq.get("address").set(address);
        opDescrReq.get("operation").set("read-operation-description");
        opDescrReq.get("name").set(operationName);
        try {
            outcome = client.execute(opDescrReq);
        }
        catch (Exception e) {
            throw new CommandFormatException("Failed to perform read-operation-description to validate the request: " + e.getLocalizedMessage());
        }
        if (!Util.isSuccess(outcome)) {
            throw new CommandFormatException("Failed to get the list of the operation properties: \"" + Util.getFailureDescription(outcome) + '\"');
        }
        if (!outcome.has("result")) {
            throw new CommandFormatException("Failed to perform read-operation-description to validate the request: result is not available.");
        }
        ModelNode result = outcome.get("result");
        if (!result.hasDefined("request-properties")) {
            throw new CommandFormatException("Operation '" + operationName + "' does not expect any property.");
        }
        Set definedProps = result.get("request-properties").keys();
        if (definedProps.isEmpty()) {
            throw new CommandFormatException("Operation '" + operationName + "' does not expect any property.");
        }
        int skipped = 0;
        for (String prop : keys) {
            if (skipped < 2 && (prop.equals("address") || prop.equals("operation"))) {
                ++skipped;
                continue;
            }
            if (definedProps.contains(prop) || "operation-headers".equals(prop)) continue;
            throw new CommandFormatException("'" + prop + "' is not found among the supported properties: " + definedProps);
        }
    }
}

