/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.RequestParameterArgument;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public abstract class BaseOperationCommand
extends CommandHandlerWithHelp
implements OperationCommand {
    protected List<RequestParameterArgument> params = new ArrayList<RequestParameterArgument>();

    public BaseOperationCommand(String command) {
        super(command);
    }

    public BaseOperationCommand(String command, boolean connectionRequired) {
        super(command, connectionRequired);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        ModelNode result;
        ModelNode request;
        try {
            request = this.buildRequest(ctx);
        }
        catch (CommandFormatException e1) {
            ctx.printLine(e1.getLocalizedMessage());
            return;
        }
        if (request == null) {
            ctx.printLine("Operation request wasn't built.");
            return;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        try {
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to perform operation: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine(Util.getFailureDescription(result));
            return;
        }
    }

    @Override
    public void addArgument(CommandArgument arg) {
        super.addArgument(arg);
        if (arg instanceof RequestParameterArgument) {
            this.params.add((RequestParameterArgument)arg);
        }
    }

    protected void setParams(CommandContext ctx, ModelNode request) throws CommandFormatException {
        for (RequestParameterArgument arg : this.params) {
            arg.set(ctx.getParsedArguments(), request);
        }
    }
}

