/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.SimpleTabCompleterWithDelegate;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class UndeployHandler
extends BatchModeCommandHandler {
    public UndeployHandler() {
        super("undeploy", true, new SimpleTabCompleterWithDelegate(new String[]{"--help", "-l"}, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int nextCharIndex;
                for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
                }
                if (ctx.getModelControllerClient() != null) {
                    List<String> deployments = Util.getDeployments(ctx.getModelControllerClient());
                    if (deployments.isEmpty()) {
                        return -1;
                    }
                    String opBuffer = buffer.substring(nextCharIndex).trim();
                    if (opBuffer.isEmpty()) {
                        candidates.addAll(deployments);
                    } else {
                        for (String name : deployments) {
                            if (!name.startsWith(opBuffer)) continue;
                            candidates.add(name);
                        }
                        Collections.sort(candidates);
                    }
                    return nextCharIndex;
                }
                return -1;
            }
        }));
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        ModelNode result;
        ModelNode request;
        ModelControllerClient client = ctx.getModelControllerClient();
        if (!ctx.hasArguments()) {
            this.printList(ctx, Util.getDeployments(client));
            return;
        }
        String deployment = null;
        List<String> args = ctx.getArguments();
        if (args.size() > 0) {
            deployment = args.get(0);
        }
        if (deployment == null) {
            this.printList(ctx, Util.getDeployments(client));
            return;
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("undeploy");
        builder.addNode("deployment", deployment);
        try {
            request = builder.buildRequest();
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to undeploy: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine("Undeploy failed: " + Util.getFailureDescription(result));
            return;
        }
        builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("remove");
        builder.addNode("deployment", deployment);
        try {
            request = builder.buildRequest();
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to remove the deployment content from the repository: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine("Remove failed: " + Util.getFailureDescription(result));
            return;
        }
        ctx.printLine("'" + deployment + "' undeployed successfully.");
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws OperationFormatException {
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        if (!ctx.hasArguments()) {
            throw new OperationFormatException("Required arguments are missing.");
        }
        String deployment = null;
        List<String> args = ctx.getArguments();
        if (args.size() > 0) {
            deployment = args.get(0);
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("undeploy");
        builder.addNode("deployment", deployment);
        steps.add(builder.buildRequest());
        builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("remove");
        builder.addNode("deployment", deployment);
        steps.add(builder.buildRequest());
        return composite;
    }
}

