/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.SimpleTabCompleterWithDelegate;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultOperationCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;

public class LsHandler
extends CommandHandlerWithHelp {
    public LsHandler() {
        this("ls");
    }

    public LsHandler(String command) {
        super(command, true, new SimpleTabCompleterWithDelegate(new String[]{"--help", "-l"}, OperationRequestCompleter.INSTANCE));
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        OperationRequestAddress address;
        String nodePath = null;
        List<String> args = ctx.getArguments();
        if (!args.isEmpty()) {
            nodePath = args.get(0);
        }
        if (nodePath != null) {
            address = new DefaultOperationRequestAddress(ctx.getPrefix());
            DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler(address);
            try {
                ctx.getOperationRequestParser().parse(nodePath, handler);
            }
            catch (CommandFormatException e) {
                ctx.printLine(e.getLocalizedMessage());
            }
        } else {
            address = ctx.getPrefix();
        }
        List<String> names = address.endsOnType() ? ctx.getOperationCandidatesProvider().getNodeNames(address) : ctx.getOperationCandidatesProvider().getNodeTypes(address);
        this.printList(ctx, names);
    }
}

