/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class UndeployHandler
extends CommandHandlerWithHelp {
    public UndeployHandler() {
        super("undeploy");
    }

    @Override
    protected void handle(CommandContext ctx, String args) {
        ModelNode result;
        ModelNode request;
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            ctx.printLine("The controller client is not available. Make sure you are connected to the controller.");
            return;
        }
        if (args == null) {
            ctx.printLine("The argument is missing.");
            return;
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("undeploy");
        builder.addNode("deployment", args);
        try {
            request = builder.buildRequest();
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to undeploy: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine("Undeploy failed: " + Util.getFailureDescription(result));
            return;
        }
        builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("remove");
        builder.addNode("deployment", args);
        try {
            request = builder.buildRequest();
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to remove the deployment content from the repository: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine("Remove failed: " + Util.getFailureDescription(result));
            return;
        }
        ctx.printLine("'" + args + "' undeployed successfully.");
    }
}

