/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.List;
import java.util.Set;
import jline.Completor;
import jline.FileNameCompletor;
import org.jboss.as.cli.operation.OperationRequestCompleter;

public class CommandCompleter
implements Completor {
    private final FileNameCompletor fnCompleter = new FileNameCompletor();
    private final OperationRequestCompleter opCompleter;
    private final Set<String> commands;

    public CommandCompleter(Set<String> commands, OperationRequestCompleter opCompleter) {
        if (commands == null) {
            throw new IllegalArgumentException("Set of commands can't be null.");
        }
        this.commands = commands;
        this.opCompleter = opCompleter;
    }

    public int complete(String buffer, int cursor, List candidates) {
        int firstCharIndex;
        for (firstCharIndex = 0; firstCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(firstCharIndex)); ++firstCharIndex) {
        }
        if (firstCharIndex == buffer.length()) {
            candidates.addAll(this.commands);
            return firstCharIndex;
        }
        char firstChar = buffer.charAt(firstCharIndex);
        if (firstChar == '.' || firstChar == ':' || firstChar == '/') {
            return -1;
        }
        if (buffer.startsWith("cd ", firstCharIndex) || buffer.startsWith("cn ", firstCharIndex) || buffer.startsWith("ls ")) {
            String opBuffer;
            int result;
            int nextCharIndex;
            for (nextCharIndex = firstCharIndex + 3; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
            }
            if (nextCharIndex < buffer.length() && buffer.charAt(nextCharIndex) == '-') {
                if ((nextCharIndex = buffer.indexOf(32, nextCharIndex)) < 0) {
                    return -1;
                }
                while (nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex))) {
                    ++nextCharIndex;
                }
            }
            if ((result = this.opCompleter.doComplete(opBuffer = buffer.substring(nextCharIndex), candidates, false)) >= 0) {
                return nextCharIndex + result;
            }
            return result;
        }
        if (buffer.startsWith("deploy ", firstCharIndex)) {
            String opBuffer;
            int result;
            int nextCharIndex;
            for (nextCharIndex = firstCharIndex + 7; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
            }
            if (nextCharIndex < buffer.length() && buffer.charAt(nextCharIndex) == '-') {
                if ((nextCharIndex = buffer.indexOf(32, nextCharIndex)) < 0) {
                    return -1;
                }
                while (nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex))) {
                    ++nextCharIndex;
                }
            }
            if ((result = this.fnCompleter.complete(opBuffer = buffer.substring(nextCharIndex), cursor, candidates)) >= 0) {
                return nextCharIndex + result;
            }
            return result;
        }
        String cmdChunk = buffer.substring(firstCharIndex);
        for (String command : this.commands) {
            if (!command.startsWith(cmdChunk)) continue;
            candidates.add(command);
        }
        return buffer.length() - cmdChunk.length();
    }
}

