/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import org.jboss.arquillian.protocol.jmx.JMXMethodExecutor;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.as.arquillian.container.AbstractDeployableContainer;
import org.jboss.as.arquillian.container.JBossAsContainerConfiguration;
import org.jboss.as.arquillian.container.MBeanServerConnectionProvider;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.ServerController;
import org.jboss.dmr.ModelNode;

public class JBossAsManagedContainer
extends AbstractDeployableContainer {
    private final Logger log = Logger.getLogger(JBossAsManagedContainer.class.getName());
    private MBeanServerConnectionProvider provider;
    private Process process;
    private Thread shutdownThread;

    public void setup(Context context, Configuration configuration) {
        super.setup(context, configuration);
        JBossAsContainerConfiguration config = this.getContainerConfiguration();
        this.provider = new MBeanServerConnectionProvider(config.getBindAddress(), config.getJmxPort());
    }

    public void start(Context context) throws LifecycleException {
        try {
            long timeout;
            String jbossHomeKey = "jboss.home";
            String jbossHomeDir = System.getProperty(jbossHomeKey);
            if (jbossHomeDir == null) {
                throw new IllegalStateException("Cannot find system property: " + jbossHomeKey);
            }
            String additionalJavaOpts = System.getProperty("jboss.options");
            File modulesJar = new File(jbossHomeDir + "/jboss-modules.jar");
            if (!modulesJar.exists()) {
                throw new IllegalStateException("Cannot find: " + modulesJar);
            }
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("java");
            if (additionalJavaOpts != null) {
                for (String opt : additionalJavaOpts.split("\\s+")) {
                    cmd.add(opt);
                }
            }
            cmd.add("-Djboss.home.dir=" + jbossHomeDir);
            cmd.add("-Dorg.jboss.boot.log.file=" + jbossHomeDir + "/standalone/log/boot.log");
            cmd.add("-Dlogging.configuration=file:" + jbossHomeDir + "/standalone/configuration/logging.properties");
            cmd.add("-jar");
            cmd.add(modulesJar.getAbsolutePath());
            cmd.add("-mp");
            cmd.add(jbossHomeDir + "/modules");
            cmd.add("-logmodule");
            cmd.add("org.jboss.logmanager");
            cmd.add("-jaxpmodule");
            cmd.add("javax.xml.jaxp-provider");
            cmd.add("org.jboss.as.standalone");
            this.log.info("Starting container with: " + ((Object)cmd).toString());
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.redirectErrorStream(true);
            this.process = processBuilder.start();
            new Thread(new ConsoleConsumer()).start();
            final Process proc = this.process;
            this.shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (proc != null) {
                        proc.destroy();
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            boolean testRunnerMBeanAvailable = false;
            MBeanServerConnection mbeanServer = null;
            for (timeout = this.getContainerConfiguration().getStartupTimeout(); timeout > 0L && !testRunnerMBeanAvailable; timeout -= 100L) {
                if (mbeanServer == null) {
                    try {
                        mbeanServer = this.getMBeanServerConnection();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                testRunnerMBeanAvailable = mbeanServer != null && mbeanServer.isRegistered(JMXTestRunnerMBean.OBJECT_NAME);
                Thread.sleep(100L);
            }
            if (!testRunnerMBeanAvailable) {
                throw new TimeoutException(String.format("Could not connect to the managed server's MBeanServer within [%d] ms", timeout));
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    public void stop(Context context) throws LifecycleException {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.process != null) {
                this.process.destroy();
                this.process.waitFor();
                this.process = null;
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    protected MBeanServerConnection getMBeanServerConnection() {
        return this.provider.getConnection();
    }

    protected ContainerMethodExecutor getContainerMethodExecutor() {
        return new JMXMethodExecutor(this.getMBeanServerConnection(), JMXMethodExecutor.ExecutionType.REMOTE);
    }

    private boolean isServerStarted() {
        try {
            ModelNode op = Util.getEmptyOperation((String)"read-attribute", (ModelNode)PathAddress.EMPTY_ADDRESS.toModelNode());
            op.get("name").set("server-state");
            ModelNode rsp = this.getModelControllerClient().execute(op);
            return "success".equals(rsp.get("outcome").asString()) && !ServerController.State.STARTING.toString().equals(rsp.get("result").asString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = JBossAsManagedContainer.this.process.getInputStream();
            InputStreamReader reader = new InputStreamReader(stream);
            boolean writeOutput = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String val = System.getProperty("org.jboss.as.writeconsole");
                    return val != null && "true".equals(val);
                }
            });
            char[] data = new char[100];
            try {
                int read = 0;
                while (read != -1) {
                    if (writeOutput) {
                        System.out.print(data);
                    }
                    read = reader.read(data);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

