/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.logging;

import java.io.File;
import java.net.URL;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;
import org.jboss.logging.Param;
import org.jboss.vfs.VirtualFile;

@MessageBundle(projectCode="JBAS")
public interface AppClientMessages {
    public static final AppClientMessages MESSAGES = (AppClientMessages)Messages.getBundle(AppClientMessages.class);

    @Message(value="Name of the app client configuration file to use (default is \"appclient.xml\")")
    public String argAppClientConfig();

    @Message(value="Display this message and exit")
    public String argHelp();

    @Message(value="Set the url of the application server instance to connect to")
    public String argHost();

    @Message(value="Load system properties from the given url")
    public String argProperties();

    @Message(value="Set a system property")
    public String argSystemProperty();

    @Message(value="Usage: ./appclient.sh [args...] myear.ear#appClient.jar [client args...]%n%nwhere args include:%n")
    public String argUsage();

    @Message(value="Print version and exit")
    public String argVersion();

    @Message(id=14420, value="You must specify the application client to execute")
    public String appClientNotSpecified();

    @Message(id=14421, value="Argument expected for option %s")
    public String argumentExpected(String var1);

    @Message(id=14422, value="Could not find application client jar in deployment")
    public RuntimeException cannotFindAppClient();

    @Message(id=14423, value="Could not find application client %s")
    public DeploymentUnitProcessingException cannotFindAppClient(String var1);

    public RuntimeException cannotFindAppClient(File var1);

    @Message(id=14424, value="Could not load application client main class")
    public RuntimeException cannotLoadAppClientMainClass(@Cause Throwable var1);

    @Message(id=14425, value="Could not load component class")
    public DeploymentUnitProcessingException cannotLoadComponentClass(@Cause Throwable var1);

    @Message(id=14426, value="Unable to load properties from URL %s")
    public String cannotLoadProperties(URL var1);

    @Message(id=14427, value="Could not start app client %s as no main class was found")
    public RuntimeException cannotStartAppClient(String var1);

    @Message(id=14428, value="Could not start app client %s as no main method was found on main class %s")
    public RuntimeException cannotStartAppClient(String var1, Class<?> var2);

    @Message(id=14429, value="Duplicate subsystem declaration")
    public XMLStreamException duplicateSubsystemDeclaration(@Param Location var1);

    @Message(id=14430, value="%s %s already declared")
    public XMLStreamException elementAlreadyDeclared(String var1, Object var2, @Param Location var3);

    @Message(id=14431, value="Failed to parse %s")
    public DeploymentUnitProcessingException failedToParseXml(@Cause Throwable var1, VirtualFile var2);

    @Message(id=14432, value="Failed to parse %s at [%d,%d]")
    public DeploymentUnitProcessingException failedToParseXml(@Cause Throwable var1, VirtualFile var2, int var3, int var4);

    @Message(id=14433, value="Malformed URL provided for option %s")
    public String malformedUrl(String var1);

    @Message(id=14434, value="More than one application client found and no app client name specified")
    public RuntimeException multipleAppClientsFound();

    @Message(id=14435, value="Model contains multiple %s nodes")
    public IllegalStateException multipleNodesFound(String var1);

    @Message(id=14436, value="Unknown option %s")
    public String unknownOption(String var1);

    @Message(id=14437, value="Could not load callback-handler class %s")
    public DeploymentUnitProcessingException couldNotLoadCallbackClass(String var1);

    @Message(id=14438, value="Could not create instance of callback-handler class %s")
    public DeploymentUnitProcessingException couldNotCreateCallbackHandler(String var1);
}

