/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.test.impl.client.deployment;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.container.test.api.BeforeDeployment;
import org.jboss.arquillian.container.test.api.DeploymentConfiguration;
import org.jboss.arquillian.container.test.impl.client.deployment.AbstractDeploymentScenarioGenerator;
import org.jboss.arquillian.container.test.spi.client.deployment.AutomaticDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentScenarioGenerator;
import org.jboss.arquillian.container.test.spi.util.ServiceLoader;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomaticDeploymentScenarioGenerator
extends AbstractDeploymentScenarioGenerator
implements DeploymentScenarioGenerator {
    AutomaticDeploymentLocator automaticDeploymentLocator = new AutomaticDeploymentLocator(){

        @Override
        public ServiceLoader<AutomaticDeployment> find() {
            return ServiceLoader.load(AutomaticDeployment.class);
        }
    };

    @Override
    protected List<DeploymentConfiguration> generateDeploymentContent(TestClass testClass) {
        ArrayList<DeploymentConfiguration> deploymentConfigurations = new ArrayList<DeploymentConfiguration>();
        ServiceLoader<AutomaticDeployment> deploymentSpis = this.automaticDeploymentLocator.find();
        for (AutomaticDeployment deploymentSpi : deploymentSpis) {
            DeploymentConfiguration deploymentConfiguration = deploymentSpi.generateDeploymentScenario(testClass);
            if (deploymentConfiguration == null) continue;
            deploymentConfigurations.add(deploymentConfiguration);
        }
        return deploymentConfigurations;
    }

    @Override
    protected Archive manipulateArchive(TestClass testClass, String deploymentName, Archive archive) {
        Method[] beforeDeploymentMethods;
        for (Method beforeDeploymentMethod : beforeDeploymentMethods = testClass.getMethods(BeforeDeployment.class)) {
            BeforeDeployment beforeDeploymentMethodAnnotation = beforeDeploymentMethod.getAnnotation(BeforeDeployment.class);
            if (!beforeDeploymentMethodAnnotation.name().equals(deploymentName)) continue;
            this.validate(beforeDeploymentMethod);
            archive = this.invoke(Archive.class, beforeDeploymentMethod, archive);
            break;
        }
        return archive;
    }

    private <T> T invoke(Class<T> type, Method deploymentMethod, Archive currentArchive) {
        try {
            return type.cast(deploymentMethod.invoke(null, currentArchive));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not invoke deployment method: " + deploymentMethod, e);
        }
    }

    private void validate(Method deploymentMethod) {
        if (!Modifier.isStatic(deploymentMethod.getModifiers())) {
            throw new IllegalArgumentException("Method annotated with " + BeforeDeployment.class.getName() + " is not static. " + deploymentMethod);
        }
        if (!Archive.class.isAssignableFrom(deploymentMethod.getReturnType())) {
            throw new IllegalArgumentException("Method annotated with " + BeforeDeployment.class.getName() + " must have return type " + Archive.class.getName() + ". " + deploymentMethod);
        }
        if (deploymentMethod.getParameterTypes().length != 1 && Archive.class == deploymentMethod.getParameterTypes()[0]) {
            throw new IllegalArgumentException("Method annotated with " + BeforeDeployment.class.getName() + " only accept one parameter of type ." + Archive.class + " " + deploymentMethod);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface AutomaticDeploymentLocator {
        public ServiceLoader<AutomaticDeployment> find();
    }
}

