/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.schedule;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import org.jberet.schedule.JobScheduleConfig;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class JobSchedule
implements Serializable,
Comparable<JobSchedule> {
    private static final long serialVersionUID = 5759369754976526021L;
    private String id;
    private final JobScheduleConfig jobScheduleConfig;
    private final Date createTime;
    private Status status = Status.SCHEDULED;
    private List<Long> jobExecutionIds = new CopyOnWriteArrayList<Long>();
    private transient Future<?> future;

    public JobSchedule() {
        this(null, null);
    }

    public JobSchedule(String id, JobScheduleConfig jobScheduleConfig) {
        this.id = id;
        this.jobScheduleConfig = jobScheduleConfig;
        this.createTime = new Date();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JobScheduleConfig getJobScheduleConfig() {
        return this.jobScheduleConfig;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<Long> getJobExecutionIds() {
        return Collections.unmodifiableList(this.jobExecutionIds);
    }

    public void addJobExecutionIds(long jobExecutionId) {
        this.jobExecutionIds.add(jobExecutionId);
    }

    @Override
    public int compareTo(JobSchedule o) {
        return this.createTime.compareTo(o.createTime);
    }

    void setStatus(Status status) {
        this.status = status;
    }

    Future<?> getFuture() {
        return this.future;
    }

    void setFuture(Future<?> future) {
        this.future = future;
    }

    public static enum Status {
        SCHEDULED,
        CANCELLED,
        DONE,
        UNKNOWN;

    }
}

