/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.runner.wicket.pages;

import com.google.inject.Inject;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.value.ValueMap;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.embedder.StoryRunner;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.reporters.TxtOutput;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.web.runner.context.StoryContext;
import org.jbehave.web.runner.context.StoryOutputStream;
import org.jbehave.web.runner.wicket.pages.Template;

public class RunStory
extends Template {
    @Inject
    private StoryRunner storyRunner;
    @Inject
    private Configuration configuration;
    @Inject
    private List<CandidateSteps> steps;
    private StoryOutputStream outputStream = new StoryOutputStream();
    private StoryContext storyContext = new StoryContext();

    public RunStory() {
        this.reportTo(this.outputStream);
        this.setPageTitle("Run Story");
        this.add(new Component[]{new StoryForm("storyForm")});
    }

    private void reportTo(OutputStream ouputStream) {
        final Properties outputPatterns = new Properties();
        outputPatterns.setProperty("beforeStory", "{0}\n");
        final Keywords keywords = this.configuration.keywords();
        boolean reportFailureTrace = false;
        this.configuration.useStoryReporterBuilder(new StoryReporterBuilder(){

            public StoryReporter build(String storyPath) {
                return new TxtOutput(new PrintStream(RunStory.this.outputStream), outputPatterns, keywords, false);
            }
        });
    }

    public void run() {
        if (StringUtils.isNotBlank((String)this.storyContext.getInput())) {
            try {
                this.outputStream.reset();
                this.storyContext.clearFailureCause();
                MetaFilter metaFilter = StringUtils.isNotBlank((String)this.storyContext.getMetaFilter()) ? new MetaFilter(this.storyContext.getMetaFilter()) : MetaFilter.EMPTY;
                this.storyRunner.run(this.configuration, this.steps, this.parseStory(this.storyContext.getInput()), metaFilter);
            }
            catch (Throwable e) {
                this.storyContext.runFailedFor(e);
            }
            this.storyContext.setOutput(this.outputStream.toString());
        }
    }

    private Story parseStory(String storyInput) {
        return this.configuration.storyParser().parseStory(storyInput);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class StoryForm
    extends Form<ValueMap> {
        public StoryForm(String id) {
            super(id, (IModel)new CompoundPropertyModel((Object)new ValueMap()));
            this.add(new Component[]{new TextArea("input").setType(String.class)});
            this.add(new Component[]{new TextArea("metaFilter").setType(String.class)});
            this.add(new Component[]{new Template.NoMarkupMultiLineLabel("output", "", "brush: plain")});
            this.add(new Component[]{new Template.NoMarkupMultiLineLabel("failure", "", "brush: java; gutter: false; collapse: true")});
            this.add(new Component[]{new Button("runButton")});
        }

        public final void onSubmit() {
            String input = (String)((ValueMap)this.getModelObject()).get((Object)"input");
            RunStory.this.storyContext.setInput(input);
            String metaFilter = (String)((ValueMap)this.getModelObject()).get((Object)"metaFilter");
            RunStory.this.storyContext.setMetaFilter(metaFilter);
            RunStory.this.run();
            MultiLineLabel output = (MultiLineLabel)this.get("output");
            output.setDefaultModelObject((Object)RunStory.this.storyContext.getOutput());
            MultiLineLabel failure = (MultiLineLabel)this.get("failure");
            failure.setDefaultModelObject((Object)RunStory.this.storyContext.getFailureStackTrace());
            if (StringUtils.isBlank((String)RunStory.this.storyContext.getFailureStackTrace())) {
                failure.setVisible(true);
            }
        }
    }
}

