/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.runner.wicket.pages;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.MapModel;
import org.apache.wicket.util.resource.IStringResourceStream;
import org.apache.wicket.util.resource.PackageResourceStream;
import org.apache.wicket.util.value.ValueMap;
import org.apache.wicket.velocity.markup.html.VelocityPanel;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.web.runner.context.StepdocContext;
import org.jbehave.web.runner.wicket.pages.Template;

public class FindSteps
extends Template {
    @Inject
    private Configuration configuration;
    @Inject
    private List<CandidateSteps> steps;
    private StepdocContext stepdocContext = new StepdocContext();

    public FindSteps() {
        this.setPageTitle("Find Steps");
        this.add(new Component[]{new StepsForm("stepsForm")});
        this.stepdocContext.setAllStepdocs(this.configuration.stepFinder().stepdocs(this.steps));
        this.stepdocContext.setStepsInstances(this.configuration.stepFinder().stepsInstances(this.steps));
    }

    public void run() {
        this.stepdocContext.clearStepdocs();
        String matchingStep = this.stepdocContext.getMatchingStep();
        if (StringUtils.isNotBlank((String)matchingStep)) {
            this.stepdocContext.addStepdocs(this.configuration.stepFinder().findMatching(matchingStep, this.steps));
        } else {
            this.stepdocContext.addAllStepdocs();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class StepsForm
    extends Form<ValueMap> {
        public StepsForm(String id) {
            super(id, (IModel)new CompoundPropertyModel((Object)new ValueMap()));
            this.setMarkupId("stepsForm");
            this.add(new Component[]{new TextArea("matchingStep").setType(String.class)});
            this.add(new Component[]{new Template.HtmlEscapingVelocityPanel("stepdocs", (IModel<? extends Map>)new MapModel(new HashMap()), (IStringResourceStream)new PackageResourceStream(FindSteps.class, "stepdocs.vm"), "brush: plain")});
            this.add(new Component[]{new Template.HtmlEscapingVelocityPanel("stepsInstances", (IModel<? extends Map>)new MapModel(new HashMap()), (IStringResourceStream)new PackageResourceStream(FindSteps.class, "stepsInstances.vm"), "brush: java")});
            this.add(new Component[]{new DropDownChoice<StepdocContext.View>("viewSelect", Arrays.asList(StepdocContext.View.values())){

                protected void onSelectionChanged(StepdocContext.View newSelection) {
                    FindSteps.this.stepdocContext.setView(newSelection);
                    StepsForm.this.updatePanels();
                    this.setResponsePage((Page)FindSteps.this);
                }

                protected boolean wantOnSelectionChangedNotifications() {
                    return true;
                }
            }});
            this.add(new Component[]{new DropDownChoice<StepdocContext.Sorting>("sortingSelect", Arrays.asList(StepdocContext.Sorting.values())){

                protected void onSelectionChanged(StepdocContext.Sorting newSelection) {
                    FindSteps.this.stepdocContext.setSorting(newSelection);
                    switch (FindSteps.this.stepdocContext.getSorting()) {
                        case BY_POSITION: {
                            FindSteps.this.run();
                            break;
                        }
                        case BY_PATTERN: {
                            FindSteps.this.stepdocContext.sortStepdocs();
                        }
                    }
                    StepsForm.this.updatePanels();
                    this.setResponsePage((Page)FindSteps.this);
                }

                protected boolean wantOnSelectionChangedNotifications() {
                    return true;
                }
            }});
            this.add(new Component[]{new Button("findButton")});
        }

        public final void onSubmit() {
            String matchingStep = (String)((ValueMap)this.getModelObject()).get((Object)"matchingStep");
            FindSteps.this.stepdocContext.setMatchingStep(matchingStep);
            FindSteps.this.run();
            this.updatePanels();
        }

        private void updatePanels() {
            this.updateStepdocsPanel();
            this.updateStepsInstancesPanel();
        }

        private void updateStepdocsPanel() {
            VelocityPanel panel = (VelocityPanel)this.get("stepdocs");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("stepdocs", FindSteps.this.stepdocContext.getStepdocs());
            map.put("view", (Object)FindSteps.this.stepdocContext.getView());
            panel.setDefaultModel((IModel)new MapModel(map));
        }

        private void updateStepsInstancesPanel() {
            VelocityPanel panel = (VelocityPanel)this.get("stepsInstances");
            HashMap map = new HashMap();
            map.put("stepsInstances", FindSteps.this.stepdocContext.getStepsClasses());
            panel.setDefaultModel((IModel)new MapModel(map));
        }
    }
}

