/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.runner.wicket.pages;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.NotImplementedException;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.MultiFileUploadField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.jbehave.web.io.FileManager;
import org.jbehave.web.runner.context.FileContext;
import org.jbehave.web.runner.wicket.pages.FileContent;
import org.jbehave.web.runner.wicket.pages.Template;

public class DataFiles
extends Template {
    @Inject
    private FileManager manager;
    private final FileContext fileContext = new FileContext();

    public DataFiles() {
        this.setPageTitle("Data Files");
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)this.fileContext));
        this.fileContext.setFiles(new ArrayList<File>(this.manager.list()));
        this.showContent();
        this.add(new Component[]{new FileListForm("listForm", this.fileContext.getFiles())});
        this.add(new Component[]{new FileContentContainer("contentContainer", this.fileContext.getContentFilesAsList())});
        this.add(new Component[]{new FileUploadForm("uploadForm")});
    }

    public void showContent() {
        Map<String, List<File>> contentFiles = this.fileContext.getContentFiles();
        contentFiles.clear();
        for (File file : this.fileContext.getFiles()) {
            List content = this.manager.listContent(file, false);
            if (content.size() <= 0) continue;
            contentFiles.put(((File)content.get(0)).getPath(), content);
        }
    }

    public void delete() {
        this.manager.delete(this.fileContext.getFiles());
    }

    public static class UploadFileItem
    implements FileItem {
        private FileUpload upload;

        public UploadFileItem(FileUpload upload) {
            this.upload = upload;
        }

        public void delete() {
            this.upload.delete();
        }

        public byte[] get() {
            return this.upload.getBytes();
        }

        public String getContentType() {
            return this.upload.getContentType();
        }

        public String getFieldName() {
            throw new NotImplementedException();
        }

        public InputStream getInputStream() throws IOException {
            return this.upload.getInputStream();
        }

        public String getName() {
            return this.upload.getClientFileName();
        }

        public OutputStream getOutputStream() throws IOException {
            throw new NotImplementedException();
        }

        public long getSize() {
            return this.upload.getSize();
        }

        public String getString() {
            throw new NotImplementedException();
        }

        public String getString(String encoding) throws UnsupportedEncodingException {
            throw new NotImplementedException();
        }

        public boolean isFormField() {
            throw new NotImplementedException();
        }

        public boolean isInMemory() {
            throw new NotImplementedException();
        }

        public void setFieldName(String name) {
            throw new NotImplementedException();
        }

        public void setFormField(boolean state) {
            throw new NotImplementedException();
        }

        public void write(File file) throws Exception {
            this.upload.writeTo(file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileUploadForm
    extends Form<Void> {
        private final Collection<FileUpload> uploads;

        public FileUploadForm(String id) {
            super(id);
            this.uploads = new ArrayList<FileUpload>();
            this.setMultiPart(true);
            this.add(new Component[]{new MultiFileUploadField("uploadInput", (IModel)new PropertyModel((Object)this, "uploads"), 5)});
            this.add(new Component[]{new Button("uploadButton"){

                public void onSubmit() {
                    List<String> errors = DataFiles.this.fileContext.getErrors();
                    List files = DataFiles.this.manager.upload(FileUploadForm.this.fileItems(FileUploadForm.this.uploads), errors);
                    DataFiles.this.manager.unarchiveFiles(files, errors);
                    this.setResponsePage(DataFiles.class);
                }
            }});
        }

        protected List<FileItem> fileItems(Collection<FileUpload> uploads) {
            ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
            for (FileUpload upload : uploads) {
                fileItems.add(new UploadFileItem(upload));
            }
            return fileItems;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FileContentContainer
    extends WebMarkupContainer {
        public FileContentContainer(String id, List<File> files) {
            super(id);
            this.add(new Component[]{new ListView<File>("file", files){

                protected void populateItem(ListItem<File> item) {
                    final File file = (File)item.getModelObject();
                    item.add(new Component[]{new Label("path", (IModel)new PropertyModel((Object)item.getDefaultModel(), "path"))});
                    item.add(new Component[]{new Link<File>("view"){

                        public void onClick() {
                            this.setResponsePage((Page)new FileContent(file));
                        }
                    }});
                }
            }});
        }

        public boolean isVisible() {
            return DataFiles.this.fileContext.getContentVisible();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileListForm
    extends Form<Void> {
        public FileListForm(String id, List<File> files) {
            super(id);
            this.add(new Component[]{new CheckBoxMultipleChoice("files", files)});
            this.add(new Component[]{new Button("showContentButton"){

                public final void onSubmit() {
                    DataFiles.this.fileContext.setContentVisible(true);
                    this.setResponsePage((Page)DataFiles.this);
                }
            }});
            this.add(new Component[]{new Button("hideContentButton"){

                public final void onSubmit() {
                    DataFiles.this.fileContext.setContentVisible(false);
                    this.setResponsePage((Page)DataFiles.this);
                }
            }});
            this.add(new Component[]{new Button("deleteButton"){

                public final void onSubmit() {
                    DataFiles.this.delete();
                    this.setResponsePage(DataFiles.class);
                }
            }});
        }
    }
}

