/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.runner.context;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileContext
implements Serializable {
    private List<File> files = new ArrayList<File>();
    private Map<String, List<File>> contentFiles = new HashMap<String, List<File>>();
    private boolean contentVisible = false;
    private List<String> errors = new ArrayList<String>();

    public List<File> getFiles() {
        return this.files;
    }

    public void setFiles(List<File> files) {
        this.files = this.toViewables(files);
    }

    public List<File> getContentFilesAsList() {
        ArrayList<File> list = new ArrayList<File>();
        for (String directoryPath : this.contentFiles.keySet()) {
            list.addAll(this.toViewables(this.contentFiles.get(directoryPath)));
        }
        return list;
    }

    private List<File> toViewables(List<File> files) {
        ArrayList<File> viewableFiles = new ArrayList<File>();
        for (File file : files) {
            ViewableFile viewableFile = new ViewableFile(file);
            if (!viewableFile.isViewable()) continue;
            viewableFiles.add(viewableFile);
        }
        return viewableFiles;
    }

    public boolean getContentVisible() {
        return this.contentVisible;
    }

    public void setContentVisible(boolean contentVisible) {
        this.contentVisible = contentVisible;
    }

    public Map<String, List<File>> getContentFiles() {
        return this.contentFiles;
    }

    public void setContentFiles(Map<String, List<File>> contentFiles) {
        this.contentFiles = contentFiles;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class ViewableFile
    extends File {
        public ViewableFile(File file) {
            super(file.getPath());
        }

        public String getPath() {
            return this.unixPath(super.getPath());
        }

        private String unixPath(String path) {
            return path.replace("\\", "/");
        }

        public boolean isViewable() {
            return this.getPath().matches(".*\\.[A-Za-z]+");
        }
    }
}

