/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.runner.waffle.controllers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioContext {
    private static final String EMPTY = "";
    private static final List<String> EMPTY_LIST = Arrays.asList(new Object[0]);
    private String input;
    private String output;
    private List<String> messages;
    private Throwable cause;

    public ScenarioContext() {
        this(EMPTY, EMPTY, EMPTY_LIST);
    }

    public ScenarioContext(String input, String output, List<String> messages) {
        this.input = input;
        this.output = output;
        this.messages = new ArrayList<String>();
        this.messages.addAll(messages);
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public List<String> getFailureMessages() {
        this.messages.clear();
        this.addFailureMessage(this.cause);
        return this.messages;
    }

    private void addFailureMessage(Throwable cause) {
        if (cause != null) {
            if (cause.getMessage() != null) {
                this.messages.add(cause.getMessage());
            }
            this.addFailureMessage(cause.getCause());
        }
    }

    public void clearFailureCause() {
        this.cause = null;
    }

    public void runFailedFor(Throwable cause) {
        this.cause = cause;
    }

    public String getFailureStackTrace() {
        StringWriter writer = new StringWriter();
        if (this.cause != null) {
            this.cause.printStackTrace(new PrintWriter(writer));
        }
        return writer.getBuffer().toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

