/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.web.runner.waffle;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.codehaus.waffle.io.RequestFileUploader;
import org.codehaus.waffle.menu.Menu;
import org.codehaus.waffle.menu.MenuAwareController;
import org.codehaus.waffle.registrar.AbstractRegistrar;
import org.codehaus.waffle.registrar.Registrar;
import org.codehaus.waffle.view.ViewResolver;
import org.jbehave.scenario.MostUsefulConfiguration;
import org.jbehave.scenario.ScenarioRunner;
import org.jbehave.scenario.parser.PatternScenarioParser;
import org.jbehave.scenario.steps.DefaultStepdocGenerator;
import org.jbehave.scenario.steps.Steps;
import org.jbehave.web.io.ArchivingFileManager;
import org.jbehave.web.io.ZipFileArchiver;
import org.jbehave.web.runner.waffle.controllers.FileUploadController;
import org.jbehave.web.runner.waffle.controllers.FilesController;
import org.jbehave.web.runner.waffle.controllers.ScenarioController;
import org.jbehave.web.runner.waffle.controllers.StepdocController;

public class JBehaveRegistrar
extends AbstractRegistrar {
    public JBehaveRegistrar(Registrar delegate) {
        super(delegate);
    }

    public void application() {
        this.registerMenu();
        this.registerConfiguration();
        this.registerScenarioParser();
        this.registerScenarioRunner();
        this.registerSteps();
        this.registerStepdocGenerator();
        this.registerFileManager();
        this.register("data/files", FilesController.class, new Object[0]);
        this.configureViews();
    }

    public void session() {
        this.register("scenario/scenario", ScenarioController.class, new Object[0]);
        this.register("scenario/stepdoc", StepdocController.class, new Object[0]);
    }

    public void request() {
        this.register(DiskFileItemFactory.class, new Object[0]);
        this.register(RequestFileUploader.class, new Object[0]);
        this.register("data/upload", FileUploadController.class, new Object[0]);
    }

    protected void registerMenu() {
        this.register("home", MenuAwareController.class, new Object[0]);
        this.registerInstance("menu", this.createMenu());
    }

    protected Menu createMenu() {
        HashMap<String, List<String>> content = new HashMap<String, List<String>>();
        content.put("Menu", Arrays.asList("Home:home", "Data Files:data/files", "Data Upload:data/upload", "Run Scenario:scenario/scenario", "Stepdoc:scenario/stepdoc"));
        return new Menu(content);
    }

    protected void configureViews() {
        ViewResolver viewResolver = (ViewResolver)this.getComponentRegistry().locateByKey(ViewResolver.class);
        viewResolver.configureView("home", "ftl/home");
        viewResolver.configureView("data/files", "ftl/data/files");
        viewResolver.configureView("data/upload", "ftl/data/upload");
        viewResolver.configureView("scenario/scenario", "ftl/scenario/scenario");
        viewResolver.configureView("scenario/stepdoc", "ftl/scenario/stepdoc");
    }

    protected void registerConfiguration() {
        this.register(MostUsefulConfiguration.class, new Object[0]);
    }

    protected void registerScenarioParser() {
        this.register(PatternScenarioParser.class, new Object[0]);
    }

    protected void registerScenarioRunner() {
        this.register(ScenarioRunner.class, new Object[0]);
    }

    protected void registerSteps() {
        this.register(Steps.class, new Object[0]);
    }

    protected void registerStepdocGenerator() {
        this.register(DefaultStepdocGenerator.class, new Object[0]);
    }

    protected void registerFileManager() {
        this.register(ZipFileArchiver.class, new Object[0]);
        this.register(ArchivingFileManager.class, new Object[0]);
        this.registerInstance("uploadDirectory", new File(System.getProperty("java.io.tmpdir") + File.separator + "upload"));
    }
}

