/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps.spring;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.AbstractStepsFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringStepsFactory
extends AbstractStepsFactory {
    private final ApplicationContext context;

    public SpringStepsFactory(Configuration configuration, ApplicationContext context) {
        super(configuration);
        this.context = context;
    }

    protected List<Object> stepsInstances() {
        ArrayList<Object> steps = new ArrayList<Object>();
        for (String name : this.context.getBeanDefinitionNames()) {
            Class type = this.context.getType(name);
            if (!this.isAllowed(type) || !this.hasAnnotatedMethods(type)) continue;
            try {
                steps.add(this.context.getBean(name));
            }
            catch (BeansException e) {
                // empty catch block
            }
        }
        return steps;
    }

    protected boolean isAllowed(Class<?> type) {
        return type != null && !Modifier.isAbstract(type.getModifiers());
    }
}

