/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.steps.spring;

import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class SpringApplicationContextFactory {
    private final ApplicationContext parent;
    private final ClassLoader classLoader;
    private final String[] resources;

    public SpringApplicationContextFactory(String ... resources) {
        this(SpringApplicationContextFactory.class.getClassLoader(), resources);
    }

    public SpringApplicationContextFactory(ClassLoader classLoader, String ... resources) {
        this(null, classLoader, resources);
    }

    public SpringApplicationContextFactory(ApplicationContext parent, ClassLoader classLoader, String ... resources) {
        this.parent = parent;
        this.classLoader = classLoader;
        this.resources = resources;
    }

    public ConfigurableApplicationContext createApplicationContext() {
        GenericApplicationContext context = new GenericApplicationContext(this.parent);
        context.setClassLoader(this.classLoader);
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(this.classLoader);
        context.setResourceLoader((ResourceLoader)resourceLoader);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)context);
        for (String resource : this.resources) {
            reader.loadBeanDefinitions(resourceLoader.getResource(resource));
        }
        context.refresh();
        return context;
    }
}

