/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.core.configuration.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbehave.core.annotations.spring.UsingSpring;
import org.jbehave.core.configuration.AnnotationBuilder;
import org.jbehave.core.configuration.AnnotationFinder;
import org.jbehave.core.configuration.AnnotationMonitor;
import org.jbehave.core.configuration.AnnotationRequired;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.CompositeStepsFactory;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.ParameterConverters;
import org.jbehave.core.steps.spring.SpringApplicationContextFactory;
import org.jbehave.core.steps.spring.SpringStepsFactory;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringAnnotationBuilder
extends AnnotationBuilder {
    private ApplicationContext context;

    public SpringAnnotationBuilder(Class<?> annotatedClass) {
        super(annotatedClass);
    }

    public SpringAnnotationBuilder(Class<?> annotatedClass, AnnotationMonitor annotationMonitor) {
        super(annotatedClass, annotationMonitor);
    }

    public Configuration buildConfiguration() throws AnnotationRequired {
        if (this.annotationFinder().isAnnotationPresent(UsingSpring.class)) {
            List resources = this.annotationFinder().getAnnotatedValues(UsingSpring.class, String.class, "resources");
            if (resources.size() > 0) {
                try {
                    this.context = this.createApplicationContext(this.annotatedClass().getClassLoader(), resources);
                }
                catch (Exception e) {
                    this.annotationMonitor().elementCreationFailed(ApplicationContext.class, e);
                }
            }
        } else {
            this.annotationMonitor().annotationNotFound(UsingSpring.class, (Object)this.annotatedClass());
        }
        return super.buildConfiguration();
    }

    public InjectableStepsFactory buildStepsFactory(Configuration configuration) {
        InjectableStepsFactory factoryUsingSteps = super.buildStepsFactory(configuration);
        if (this.context != null) {
            return new CompositeStepsFactory(new InjectableStepsFactory[]{new SpringStepsFactory(configuration, this.context), factoryUsingSteps});
        }
        return factoryUsingSteps;
    }

    protected ParameterConverters parameterConverters(AnnotationFinder annotationFinder) {
        ParameterConverters converters = super.parameterConverters(annotationFinder);
        if (this.context != null) {
            return converters.addConverters(this.getBeansOfType(this.context, ParameterConverters.ParameterConverter.class));
        }
        return converters;
    }

    private List<ParameterConverters.ParameterConverter> getBeansOfType(ApplicationContext context, Class<ParameterConverters.ParameterConverter> type) {
        Map beansOfType = context.getBeansOfType(type);
        ArrayList<ParameterConverters.ParameterConverter> converters = new ArrayList<ParameterConverters.ParameterConverter>();
        for (ParameterConverters.ParameterConverter converter : beansOfType.values()) {
            converters.add(converter);
        }
        return converters;
    }

    protected <T, V extends T> T instanceOf(Class<T> type, Class<V> ofClass) {
        Map beansOfType;
        if (this.context != null && (beansOfType = !type.equals(Object.class) ? this.context.getBeansOfType(type) : this.context.getBeansOfType(ofClass)).size() > 0) {
            return (T)beansOfType.values().iterator().next();
        }
        return (T)super.instanceOf(type, ofClass);
    }

    protected ApplicationContext createApplicationContext(ClassLoader classLoader, List<String> resources) {
        if (this.context != null) {
            return this.context;
        }
        return new SpringApplicationContextFactory(classLoader, resources.toArray(new String[resources.size()])).createApplicationContext();
    }

    protected ApplicationContext applicationContext() {
        return this.context;
    }
}

